/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http;

import java.util.List;
import org.dromara.hutool.core.net.url.UrlBuilder;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.http.HttpUtil;

public class HttpUrlUtil {
    public static UrlBuilder getLocationUrl(UrlBuilder parentUrl, String location) {
        UrlBuilder redirectUrl;
        if (!HttpUtil.isHttp(location) && !HttpUtil.isHttps(location)) {
            String query;
            List<String> split;
            if (!location.startsWith("/")) {
                location = StrUtil.addSuffixIfNot(parentUrl.getPathStr(), "/") + location;
            }
            if ((split = SplitUtil.split(location, "?", 2, true, true)).size() == 2) {
                location = split.get(0);
                query = split.get(1);
            } else {
                query = null;
            }
            redirectUrl = UrlBuilder.of(parentUrl.getScheme(), parentUrl.getHost(), parentUrl.getPort(), location, query, null, parentUrl.getCharset());
        } else {
            redirectUrl = UrlBuilder.ofHttpWithoutEncode(location);
        }
        return redirectUrl;
    }
}

