/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.stream.spliterators;

import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class DropWhileSpliterator<T>
implements Spliterator<T> {
    private final Spliterator<T> source;
    private final Predicate<? super T> predicate;
    private boolean isFound = false;

    public static <T> DropWhileSpliterator<T> of(Spliterator<T> source, Predicate<? super T> predicate) {
        return new DropWhileSpliterator<T>(source, predicate);
    }

    public DropWhileSpliterator(Spliterator<T> source, Predicate<? super T> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        boolean hasNext = true;
        while (!this.isFound && hasNext) {
            hasNext = this.source.tryAdvance(e -> {
                if (!this.predicate.test(e)) {
                    this.isFound = true;
                    action.accept(e);
                }
            });
        }
        if (this.isFound) {
            this.source.forEachRemaining(action);
        }
        return false;
    }

    @Override
    public Spliterator<T> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return this.source.characteristics() & 0xFFFFFFBF;
    }

    @Override
    public Comparator<? super T> getComparator() {
        return this.source.getComparator();
    }
}

