/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.net.url;

import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import org.dromara.hutool.core.codec.PercentCodec;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.iter.IterUtil;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.map.TableMap;
import org.dromara.hutool.core.net.url.FormUrlencoded;
import org.dromara.hutool.core.net.url.RFC3986;
import org.dromara.hutool.core.net.url.UrlDecoder;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class UrlQuery {
    private final TableMap<CharSequence, CharSequence> query;
    private EncodeMode encodeMode;

    public static UrlQuery of(String queryStr, Charset charset) {
        return UrlQuery.of(queryStr, charset, true);
    }

    public static UrlQuery of(String queryStr, Charset charset, boolean autoRemovePath) {
        return UrlQuery.of(queryStr, charset, autoRemovePath, null);
    }

    public static UrlQuery of(String queryStr, Charset charset, boolean autoRemovePath, EncodeMode encodeMode) {
        return UrlQuery.of(encodeMode).parse(queryStr, charset, autoRemovePath);
    }

    public static UrlQuery of() {
        return UrlQuery.of(EncodeMode.NORMAL);
    }

    public static UrlQuery of(EncodeMode encodeMode) {
        return new UrlQuery(null, encodeMode);
    }

    public static UrlQuery of(Map<? extends CharSequence, ?> queryMap) {
        return UrlQuery.of(queryMap, null);
    }

    public static UrlQuery of(Map<? extends CharSequence, ?> queryMap, EncodeMode encodeMode) {
        return new UrlQuery(queryMap, encodeMode);
    }

    public UrlQuery(Map<? extends CharSequence, ?> queryMap, EncodeMode encodeMode) {
        if (MapUtil.isNotEmpty(queryMap)) {
            this.query = new TableMap(queryMap.size());
            this.addAll(queryMap);
        } else {
            this.query = new TableMap(16);
        }
        this.encodeMode = ObjUtil.defaultIfNull(encodeMode, EncodeMode.NORMAL);
    }

    public UrlQuery setEncodeMode(EncodeMode encodeMode) {
        this.encodeMode = encodeMode;
        return this;
    }

    public UrlQuery add(CharSequence key, Object value) {
        this.query.put(key, UrlQuery.toStr(value));
        return this;
    }

    public UrlQuery addAll(Map<? extends CharSequence, ?> queryMap) {
        if (MapUtil.isNotEmpty(queryMap)) {
            queryMap.forEach(this::add);
        }
        return this;
    }

    public UrlQuery remove(CharSequence key) {
        this.query.remove(key);
        return this;
    }

    public UrlQuery parse(String queryStr, Charset charset) {
        return this.parse(queryStr, charset, true);
    }

    public UrlQuery parse(String queryStr, Charset charset, boolean autoRemovePath) {
        int pathEndPos;
        if (StrUtil.isBlank(queryStr)) {
            return this;
        }
        if (autoRemovePath && (pathEndPos = queryStr.indexOf(63)) > -1 && StrUtil.isBlank(queryStr = StrUtil.subSuf(queryStr, pathEndPos + 1))) {
            return this;
        }
        return this.doParse(queryStr, charset);
    }

    public Map<CharSequence, CharSequence> getQueryMap() {
        return MapUtil.view(this.query);
    }

    public CharSequence get(CharSequence key) {
        if (MapUtil.isEmpty(this.query)) {
            return null;
        }
        return this.query.get(key);
    }

    public String build(Charset charset) {
        switch (this.encodeMode) {
            case FORM_URL_ENCODED: {
                return this.build(FormUrlencoded.ALL, FormUrlencoded.ALL, charset);
            }
            case STRICT: {
                return this.build(RFC3986.QUERY_PARAM_NAME_STRICT, RFC3986.QUERY_PARAM_VALUE_STRICT, charset);
            }
        }
        return this.build(RFC3986.QUERY_PARAM_NAME, RFC3986.QUERY_PARAM_VALUE, charset);
    }

    public String build(PercentCodec keyCoder, PercentCodec valueCoder, Charset charset) {
        if (MapUtil.isEmpty(this.query)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<CharSequence, CharSequence> entry : this.query) {
            CharSequence name = entry.getKey();
            if (null == name) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(keyCoder.encode(name, charset, new char[0]));
            CharSequence value = entry.getValue();
            if (null == value) continue;
            sb.append("=").append(valueCoder.encode(value, charset, new char[0]));
        }
        return sb.toString();
    }

    public String toString() {
        return this.build(null);
    }

    private UrlQuery doParse(String queryStr, Charset charset) {
        int i;
        int len = queryStr.length();
        String name = null;
        int pos = 0;
        block4: for (i = 0; i < len; ++i) {
            char c = queryStr.charAt(i);
            switch (c) {
                case '=': {
                    if (null != name) continue block4;
                    name = queryStr.substring(pos, i);
                    pos = i + 1;
                    continue block4;
                }
                case '&': {
                    this.addParam(name, queryStr.substring(pos, i), charset);
                    name = null;
                    if (i + 4 < len && "amp;".equals(queryStr.substring(i + 1, i + 5))) {
                        i += 4;
                    }
                    pos = i + 1;
                }
            }
        }
        this.addParam(name, queryStr.substring(pos, i), charset);
        return this;
    }

    private static String toStr(Object value) {
        String result = value instanceof Iterable ? CollUtil.join((Iterable)value, ",") : (value instanceof Iterator ? IterUtil.join((Iterator)value, ",") : ConvertUtil.toStr(value));
        return result;
    }

    private void addParam(String key, String value, Charset charset) {
        boolean isFormUrlEncoded;
        boolean bl = isFormUrlEncoded = EncodeMode.FORM_URL_ENCODED == this.encodeMode;
        if (null != key) {
            String actualKey = UrlDecoder.decode(key, charset, isFormUrlEncoded);
            this.query.put(actualKey, StrUtil.toStringOrEmpty(UrlDecoder.decode(value, charset, isFormUrlEncoded)));
        } else if (null != value) {
            this.query.put(UrlDecoder.decode(value, charset, isFormUrlEncoded), null);
        }
    }

    public static enum EncodeMode {
        NORMAL,
        FORM_URL_ENCODED,
        STRICT;

    }
}

