/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.net.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.net.ssl.TrustAnyTrustManager;
import org.dromara.hutool.core.text.StrUtil;

public class TrustManagerUtil {
    public static final X509TrustManager[] TRUST_ANYS = new X509TrustManager[]{TrustAnyTrustManager.INSTANCE};

    public static X509TrustManager getDefaultTrustManager() {
        return TrustManagerUtil.getTrustManager(null, null);
    }

    public static X509TrustManager getTrustManager(KeyStore keyStore, Provider provider) {
        return TrustManagerUtil.getTrustManager(keyStore, null, provider);
    }

    public static X509TrustManager getTrustManager(KeyStore keyStore, String algorithm, Provider provider) {
        TrustManager[] tms;
        for (TrustManager tm : tms = TrustManagerUtil.getTrustManagers(keyStore, algorithm, provider)) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        return null;
    }

    public static TrustManager[] getDefaultTrustManagers() {
        return TrustManagerUtil.getTrustManagers(null);
    }

    public static TrustManager[] getTrustManagers(KeyStore keyStore) {
        return TrustManagerUtil.getTrustManagers(keyStore, null, null);
    }

    public static TrustManager[] getTrustManagers(KeyStore keyStore, String algorithm, Provider provider) {
        return TrustManagerUtil.getTrustManagerFactory(keyStore, algorithm, provider).getTrustManagers();
    }

    public static TrustManagerFactory getTrustManagerFactory(KeyStore keyStore, String algorithm, Provider provider) {
        TrustManagerFactory tmf;
        if (StrUtil.isEmpty(algorithm)) {
            algorithm = TrustManagerFactory.getDefaultAlgorithm();
        }
        try {
            tmf = null == provider ? TrustManagerFactory.getInstance(algorithm) : TrustManagerFactory.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HutoolException(e);
        }
        try {
            tmf.init(keyStore);
        }
        catch (KeyStoreException e) {
            throw new HutoolException(e);
        }
        return tmf;
    }
}

