/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.file;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.util.CharsetUtil;

public class FileSystemUtil {
    public static FileSystem of(String path) {
        try {
            return FileSystems.newFileSystem(Paths.get(path, new String[0]).toUri(), MapUtil.of("create", "true"));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static FileSystem createZip(String path) {
        return FileSystemUtil.createZip(path, null);
    }

    public static FileSystem createZip(String path, Charset charset) {
        if (null == charset) {
            charset = CharsetUtil.UTF_8;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        env.put("encoding", charset.name());
        try {
            return FileSystems.newFileSystem(URI.create("jar:" + Paths.get(path, new String[0]).toUri()), env);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Path getRoot(FileSystem fileSystem) {
        return fileSystem.getPath("/", new String[0]);
    }
}

