/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.collection.queue;

import java.util.Collection;
import java.util.function.Predicate;
import org.dromara.hutool.core.collection.queue.CheckedLinkedBlockingQueue;
import org.dromara.hutool.core.lang.Console;
import org.dromara.hutool.core.thread.SimpleScheduler;
import org.dromara.hutool.core.util.RuntimeUtil;

public class MemorySafeLinkedBlockingQueue<E>
extends CheckedLinkedBlockingQueue<E> {
    private static final long serialVersionUID = 1L;

    public MemorySafeLinkedBlockingQueue(long maxFreeMemory) {
        super(new MemoryChecker(maxFreeMemory));
    }

    public MemorySafeLinkedBlockingQueue(Collection<? extends E> c, long maxFreeMemory) {
        super(c, new MemoryChecker(maxFreeMemory));
    }

    public void setMaxFreeMemory(int maxFreeMemory) {
        ((MemoryChecker)this.checker).maxFreeMemory = maxFreeMemory;
    }

    public long getMaxFreeMemory() {
        return ((MemoryChecker)this.checker).maxFreeMemory;
    }

    private static class FreeMemoryCalculator
    extends SimpleScheduler<Long> {
        private static final FreeMemoryCalculator INSTANCE = new FreeMemoryCalculator();

        FreeMemoryCalculator() {
            super(new SimpleScheduler.Job<Long>(){
                private volatile long maxAvailable = RuntimeUtil.getFreeMemory();

                @Override
                public Long getResult() {
                    return this.maxAvailable;
                }

                @Override
                public void run() {
                    this.maxAvailable = RuntimeUtil.getFreeMemory();
                }
            }, 50L);
        }
    }

    private static class MemoryChecker<E>
    implements Predicate<E> {
        private long maxFreeMemory;

        private MemoryChecker(long maxFreeMemory) {
            this.maxFreeMemory = maxFreeMemory;
        }

        @Override
        public boolean test(E e) {
            Console.log(FreeMemoryCalculator.INSTANCE.getResult());
            return (Long)FreeMemoryCalculator.INSTANCE.getResult() > this.maxFreeMemory;
        }
    }
}

