/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.codec;

import java.nio.ByteOrder;
import java.util.Objects;

public class Number128
extends Number
implements Comparable<Number128> {
    private static final long serialVersionUID = 1L;
    private long mostSigBits;
    private long leastSigBits;

    public Number128(long mostSigBits, long leastSigBits) {
        this.mostSigBits = mostSigBits;
        this.leastSigBits = leastSigBits;
    }

    public long getMostSigBits() {
        return this.mostSigBits;
    }

    public void setMostSigBits(long hiValue) {
        this.mostSigBits = hiValue;
    }

    public long getLeastSigBits() {
        return this.leastSigBits;
    }

    public void setLeastSigBits(long leastSigBits) {
        this.leastSigBits = leastSigBits;
    }

    public long[] getLongArray(ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return new long[]{this.leastSigBits, this.mostSigBits};
        }
        return new long[]{this.mostSigBits, this.leastSigBits};
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        return this.leastSigBits;
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Number128) {
            Number128 number128 = (Number128)o;
            return this.leastSigBits == number128.leastSigBits && this.mostSigBits == number128.mostSigBits;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.leastSigBits, this.mostSigBits);
    }

    @Override
    public int compareTo(Number128 o) {
        int mostSigBits = Long.compare(this.mostSigBits, o.mostSigBits);
        return mostSigBits != 0 ? mostSigBits : Long.compare(this.leastSigBits, o.leastSigBits);
    }
}

