/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.cache.impl;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.dromara.hutool.core.cache.impl.CacheObj;
import org.dromara.hutool.core.cache.impl.LockedCache;
import org.dromara.hutool.core.thread.lock.NoLock;

public class LFUCache<K, V>
extends LockedCache<K, V> {
    private static final long serialVersionUID = 1L;

    public LFUCache(int capacity) {
        this(capacity, 0L);
    }

    public LFUCache(int capacity, long timeout) {
        if (Integer.MAX_VALUE == capacity) {
            --capacity;
        }
        this.capacity = capacity;
        this.timeout = timeout;
        this.lock = NoLock.INSTANCE;
        this.cacheMap = new ConcurrentHashMap(capacity + 1, 1.0f);
    }

    @Override
    protected int pruneCache() {
        int count = 0;
        CacheObj comin = null;
        Iterator values = this.cacheObjIter();
        while (values.hasNext()) {
            CacheObj co = values.next();
            if (co.isExpired()) {
                values.remove();
                this.onRemove(co.key, co.obj);
                ++count;
                continue;
            }
            if (comin != null && co.accessCount.get() >= comin.accessCount.get()) continue;
            comin = co;
        }
        if (this.isFull() && comin != null) {
            long minAccessCount = comin.accessCount.get();
            values = this.cacheObjIter();
            while (values.hasNext()) {
                CacheObj co1 = values.next();
                if (co1.accessCount.addAndGet(-minAccessCount) > 0L) continue;
                values.remove();
                this.onRemove(co1.key, co1.obj);
                ++count;
            }
        }
        return count;
    }
}

