/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean.copier;

import java.lang.reflect.Type;
import java.util.Map;
import org.dromara.hutool.core.bean.PropDesc;
import org.dromara.hutool.core.bean.copier.AbsCopier;
import org.dromara.hutool.core.bean.copier.CopyOptions;
import org.dromara.hutool.core.bean.copier.ValueProvider;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.text.StrUtil;

public class ValueProviderToBeanCopier<T>
extends AbsCopier<ValueProvider<String>, T> {
    private final Type targetType;

    public ValueProviderToBeanCopier(ValueProvider<String> source, T target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        this.targetType = targetType;
    }

    @Override
    public T copy() {
        Class<?> actualEditable = this.target.getClass();
        if (null != this.copyOptions.editable) {
            Assert.isTrue(this.copyOptions.editable.isInstance(this.target), "Target class [{}] not assignable to Editable class [{}]", actualEditable.getName(), this.copyOptions.editable.getName());
            actualEditable = this.copyOptions.editable;
        }
        Map<String, PropDesc> targetPropDescMap = this.getBeanDesc(actualEditable).getPropMap(this.copyOptions.ignoreCase);
        targetPropDescMap.forEach((tFieldName, propDesc) -> {
            if (null == tFieldName) {
                return;
            }
            if (null == propDesc || !propDesc.isWritable(this.copyOptions.transientSupport)) {
                return;
            }
            Type fieldType = TypeUtil.getActualType(this.targetType, propDesc.getFieldType());
            MutableEntry<Object, Object> entry = this.copyOptions.editField(tFieldName, null);
            if (null == entry) {
                return;
            }
            tFieldName = StrUtil.toStringOrNull(entry.getKey());
            if (null == tFieldName) {
                return;
            }
            if (!((ValueProvider)this.source).containsKey(tFieldName)) {
                return;
            }
            Object sValue = ((ValueProvider)this.source).value(tFieldName, fieldType);
            if (!this.copyOptions.testPropertyFilter(propDesc.getField(), sValue)) {
                return;
            }
            propDesc.setValue(this.target, sValue, this.copyOptions.ignoreNullValue, this.copyOptions.ignoreError, this.copyOptions.override);
        });
        return (T)this.target;
    }
}

