/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.core.toolkit;

import java.util.Arrays;
import java.util.Optional;
import org.dromara.easyes.common.enums.Link;
import org.dromara.easyes.common.enums.Query;
import org.dromara.easyes.common.params.SFunction;
import org.dromara.easyes.core.toolkit.FieldUtils;

public class QueryUtils {
    private static final String OPEN = "(";
    private static final String CLOSE = ")";
    private static final String COLON = ":";

    public static <T> String buildQueryString(SFunction<T, ?> column, Object value) {
        return QueryUtils.buildQueryString(column, value, Query.MATCH, null);
    }

    public static <T> String buildQueryString(SFunction<T, ?> column, Object value, Query query) {
        return QueryUtils.buildQueryString(column, value, query, null);
    }

    public static <T> String buildQueryString(SFunction<T, ?> column, Object value, Link link) {
        return QueryUtils.buildQueryString(column, value, Query.MATCH, link);
    }

    public static <T> String buildQueryString(SFunction<T, ?> column, Object value, Query query, Link link) {
        StringBuilder sb = new StringBuilder();
        sb.append(OPEN).append(FieldUtils.val(column)).append(query.getText()).append(COLON).append(value).append(CLOSE);
        Optional.ofNullable(link).ifPresent(sb::append);
        return sb.toString();
    }

    public static String combine(String ... queryString) {
        return QueryUtils.combine(null, queryString);
    }

    public static String combine(Link link, String ... queryString) {
        StringBuilder sb = new StringBuilder();
        sb.append(OPEN);
        Arrays.stream(queryString).forEach(sb::append);
        sb.append(CLOSE);
        Optional.ofNullable(link).ifPresent(sb::append);
        return sb.toString();
    }

    private QueryUtils() {
    }
}

