/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.core.toolkit;

import com.alibaba.fastjson.parser.deserializer.ExtraProcessor;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.dromara.easyes.annotation.Distance;
import org.dromara.easyes.annotation.HighLight;
import org.dromara.easyes.annotation.IndexField;
import org.dromara.easyes.annotation.IndexId;
import org.dromara.easyes.annotation.IndexName;
import org.dromara.easyes.annotation.InnerIndexField;
import org.dromara.easyes.annotation.MultiIndexField;
import org.dromara.easyes.annotation.Score;
import org.dromara.easyes.annotation.rely.DefaultNestedClass;
import org.dromara.easyes.annotation.rely.FieldType;
import org.dromara.easyes.annotation.rely.IdType;
import org.dromara.easyes.annotation.rely.RefreshPolicy;
import org.dromara.easyes.common.constants.BaseEsConstants;
import org.dromara.easyes.common.utils.ArrayUtils;
import org.dromara.easyes.common.utils.Assert;
import org.dromara.easyes.common.utils.ClassUtils;
import org.dromara.easyes.common.utils.FastJsonUtils;
import org.dromara.easyes.common.utils.ReflectionKit;
import org.dromara.easyes.common.utils.StringUtils;
import org.dromara.easyes.core.biz.EntityFieldInfo;
import org.dromara.easyes.core.biz.EntityInfo;
import org.dromara.easyes.core.biz.HighLightParam;
import org.dromara.easyes.core.cache.BaseCache;
import org.dromara.easyes.core.cache.GlobalConfigCache;
import org.dromara.easyes.core.config.GlobalConfig;
import org.dromara.easyes.core.toolkit.IndexUtils;

public class EntityInfoHelper {
    private static final Map<Class<?>, EntityInfo> ENTITY_INFO_CACHE = new ConcurrentHashMap();

    public static EntityInfo getEntityInfo(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        EntityInfo entityInfo = ENTITY_INFO_CACHE.get(ClassUtils.getUserClass(clazz));
        if (null != entityInfo) {
            return entityInfo;
        }
        for (Class<?> currentClass = clazz; null == entityInfo && Object.class != currentClass; currentClass = currentClass.getSuperclass()) {
            entityInfo = ENTITY_INFO_CACHE.get(ClassUtils.getUserClass(currentClass));
        }
        if (entityInfo != null) {
            ENTITY_INFO_CACHE.put(ClassUtils.getUserClass(clazz), entityInfo);
        }
        GlobalConfig globalConfig = GlobalConfigCache.getGlobalConfig();
        return EntityInfoHelper.initIndexInfo(globalConfig, clazz);
    }

    public static synchronized EntityInfo initIndexInfo(GlobalConfig globalConfig, Class<?> clazz) {
        EntityInfo entityInfo = ENTITY_INFO_CACHE.get(clazz);
        if (entityInfo != null) {
            return entityInfo;
        }
        entityInfo = new EntityInfo();
        EntityInfoHelper.initIndexName(clazz, globalConfig, entityInfo);
        EntityInfoHelper.initIndexFields(clazz, globalConfig, entityInfo);
        ENTITY_INFO_CACHE.put(clazz, entityInfo);
        return entityInfo;
    }

    public static void initIndexFields(Class<?> clazz, GlobalConfig globalConfig, EntityInfo entityInfo) {
        GlobalConfig.DbConfig dbConfig = globalConfig.getDbConfig();
        List<Field> list = EntityInfoHelper.getAllFields(clazz);
        boolean isReadPK = false;
        boolean existsIndexId = EntityInfoHelper.isExistIndexId(list);
        ArrayList<EntityFieldInfo> fieldList = new ArrayList<EntityFieldInfo>();
        for (Field field : list) {
            if (!isReadPK && (isReadPK = existsIndexId ? EntityInfoHelper.initIndexIdWithAnnotation(dbConfig, entityInfo, field) : EntityInfoHelper.initIndexIdWithoutAnnotation(dbConfig, entityInfo, field)) || EntityInfoHelper.initIndexFieldWithAnnotation(dbConfig, fieldList, field, entityInfo)) continue;
            EntityInfoHelper.initIndexFieldWithoutAnnotation(dbConfig, fieldList, field, entityInfo);
        }
        entityInfo.setFieldList(fieldList);
        EntityInfoHelper.addSimplePropertyPreFilter(entityInfo, clazz);
        EntityInfoHelper.addExtraProcessor(entityInfo);
    }

    private static void addSimplePropertyPreFilter(EntityInfo entityInfo, Class<?> clazz) {
        ArrayList<SerializeFilter> preFilters = new ArrayList<SerializeFilter>();
        SimplePropertyPreFilter entityClassPreFilter = FastJsonUtils.getSimplePropertyPreFilter(clazz, entityInfo.getNotSerializeField());
        Optional.ofNullable(entityClassPreFilter).ifPresent(preFilters::add);
        entityInfo.getNestedNotSerializeField().forEach((k, v) -> Optional.ofNullable(FastJsonUtils.getSimplePropertyPreFilter((Class)k, (Set)v)).ifPresent(preFilters::add));
        if (!entityInfo.isChild()) {
            HashSet<String> notSerialField = new HashSet<String>();
            notSerialField.add("parent");
            Optional.ofNullable(FastJsonUtils.getSimplePropertyPreFilter(entityInfo.getJoinFieldClass(), notSerialField)).ifPresent(preFilters::add);
        }
        EntityInfoHelper.addNameFilter(entityInfo, preFilters);
        entityInfo.getClassSimplePropertyPreFilterMap().putIfAbsent(clazz, preFilters);
        entityInfo.getNotSerializeField().clear();
        entityInfo.getNestedNotSerializeField().clear();
    }

    private static void addExtraProcessor(EntityInfo entityInfo) {
        Map<String, String> columnMappingMap = entityInfo.getColumnMappingMap();
        Map<Class<?>, Map<String, String>> nestedClassColumnMappingMap = entityInfo.getNestedClassColumnMappingMap();
        ExtraProcessor extraProcessor = (object, key, value) -> {
            Map nestedColumnMappingMap = (Map)nestedClassColumnMappingMap.get(object.getClass());
            if (nestedColumnMappingMap != null) {
                EntityInfoHelper.invokeExtraProcessor(nestedColumnMappingMap, object, key, value, object.getClass());
            } else {
                EntityInfoHelper.invokeExtraProcessor(columnMappingMap, object, key, value, object.getClass());
            }
        };
        entityInfo.setExtraProcessor(extraProcessor);
    }

    private static void invokeExtraProcessor(Map<String, String> columnMappingMap, Object object, String key, Object value, Class<?> clazz) {
        Optional.ofNullable(columnMappingMap.get(key)).flatMap(realMethodName -> Optional.ofNullable(BaseCache.setterMethod(clazz, realMethodName))).ifPresent(method -> {
            try {
                method.invoke(object, value);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
    }

    private static void addNameFilter(EntityInfo entityInfo, List<SerializeFilter> preFilters) {
        Map<String, String> mappingColumnMap = entityInfo.getMappingColumnMap();
        Map<Class<?>, Map<String, String>> nestedClassMappingColumnMap = entityInfo.getNestedClassMappingColumnMap();
        if (!mappingColumnMap.isEmpty()) {
            NameFilter nameFilter = (object, name, value) -> {
                Map nestedMappingColumnMap = (Map)nestedClassMappingColumnMap.get(object.getClass());
                if (Objects.nonNull(nestedMappingColumnMap)) {
                    String nestedMappingColumn = (String)nestedMappingColumnMap.get(name);
                    if (Objects.equals(nestedMappingColumn, name)) {
                        return name;
                    }
                    return nestedMappingColumn;
                }
                String mappingColumn = (String)mappingColumnMap.get(name);
                if (Objects.equals(mappingColumn, name)) {
                    return name;
                }
                return mappingColumn;
            };
            preFilters.add((SerializeFilter)nameFilter);
        }
    }

    private static boolean initIndexFieldWithAnnotation(GlobalConfig.DbConfig dbConfig, List<EntityFieldInfo> fieldList, Field field, EntityInfo entityInfo) {
        boolean hasAnnotation = false;
        if (field.isAnnotationPresent(IndexField.class) || field.isAnnotationPresent(MultiIndexField.class)) {
            EntityInfoHelper.initIndexFieldAnnotation(dbConfig, entityInfo, field, fieldList);
            hasAnnotation = true;
        }
        if (field.isAnnotationPresent(HighLight.class)) {
            EntityInfoHelper.initHighLightAnnotation(dbConfig, entityInfo, field);
        }
        if (field.isAnnotationPresent(Score.class)) {
            entityInfo.setScoreField(field.getName());
            entityInfo.getNotSerializeField().add(field.getName());
            entityInfo.setScoreDecimalPlaces(field.getAnnotation(Score.class).decimalPlaces());
            hasAnnotation = true;
        }
        if (field.isAnnotationPresent(Distance.class)) {
            Distance distance = field.getAnnotation(Distance.class);
            entityInfo.getDistanceFields().add(field.getName());
            entityInfo.getNotSerializeField().add(field.getName());
            entityInfo.getDistanceDecimalPlaces().add(distance.decimalPlaces());
            hasAnnotation = true;
        }
        return hasAnnotation;
    }

    private static void initIndexFieldAnnotation(GlobalConfig.DbConfig dbConfig, EntityInfo entityInfo, Field field, List<EntityFieldInfo> fieldList) {
        MultiIndexField multiIndexField = field.getAnnotation(MultiIndexField.class);
        IndexField indexField = Optional.ofNullable(multiIndexField).map(MultiIndexField::mainIndexField).orElse(field.getAnnotation(IndexField.class));
        if (indexField.exist()) {
            FieldType fieldType;
            String mappingColumn;
            EntityFieldInfo entityFieldInfo = new EntityFieldInfo(dbConfig, field, indexField);
            if (!StringUtils.isBlank((CharSequence)indexField.value().trim())) {
                entityInfo.getMappingColumnMap().putIfAbsent(field.getName(), indexField.value());
                entityInfo.getColumnMappingMap().putIfAbsent(indexField.value(), field.getName());
                mappingColumn = indexField.value();
            } else {
                mappingColumn = EntityInfoHelper.initMappingColumnMapAndGet(dbConfig, entityInfo, field);
            }
            if (BaseEsConstants.MINUS_ONE.intValue() != indexField.scalingFactor()) {
                entityFieldInfo.setScalingFactor(indexField.scalingFactor());
            }
            if (StringUtils.isNotBlank((CharSequence)indexField.dateFormat())) {
                entityFieldInfo.setDateFormat(indexField.dateFormat());
            }
            if (FieldType.KEYWORD.equals((Object)(fieldType = FieldType.getByType((String)IndexUtils.getEsFieldType(indexField.fieldType(), field.getType().getSimpleName()))))) {
                entityFieldInfo.setIgnoreCase(indexField.ignoreCase());
            }
            if (indexField.ignoreAbove() > BaseEsConstants.ZERO) {
                entityFieldInfo.setIgnoreAbove(indexField.ignoreAbove());
            }
            entityFieldInfo.setMappingColumn(mappingColumn);
            entityFieldInfo.setAnalyzer(indexField.analyzer());
            entityFieldInfo.setSearchAnalyzer(indexField.searchAnalyzer());
            entityFieldInfo.setFieldType(fieldType);
            entityFieldInfo.setFieldData(indexField.fieldData());
            entityFieldInfo.setColumnType(field.getType().getSimpleName());
            entityInfo.getFieldTypeMap().putIfAbsent(field.getName(), fieldType.getType());
            if (FieldType.JOIN.equals((Object)indexField.fieldType())) {
                entityFieldInfo.setParentName(indexField.parentName());
                entityFieldInfo.setChildName(indexField.childName());
                entityInfo.setJoinFieldName(mappingColumn);
                entityInfo.setJoinFieldClass(indexField.joinFieldClass());
                entityInfo.getPathClassMap().putIfAbsent(field.getName(), indexField.joinFieldClass());
                EntityInfoHelper.processNested(indexField.joinFieldClass(), dbConfig, entityInfo);
            }
            InnerIndexField[] innerIndexFields = Optional.ofNullable(multiIndexField).map(MultiIndexField::otherIndexFields).orElse(null);
            EntityInfoHelper.processInnerField(innerIndexFields, entityFieldInfo);
            fieldList.add(entityFieldInfo);
            if (DefaultNestedClass.class != indexField.nestedClass()) {
                entityInfo.getPathClassMap().putIfAbsent(field.getName(), indexField.nestedClass());
                EntityInfoHelper.processNested(indexField.nestedClass(), dbConfig, entityInfo);
            }
        } else {
            entityInfo.getNotSerializeField().add(field.getName());
        }
    }

    private static void initHighLightAnnotation(GlobalConfig.DbConfig dbConfig, EntityInfo entityInfo, Field field) {
        String realHighLightField;
        HighLight highLight = field.getAnnotation(HighLight.class);
        String mappingField = highLight.mappingField();
        if (StringUtils.isNotBlank((CharSequence)mappingField)) {
            entityInfo.getNotSerializeField().add(mappingField);
        } else {
            mappingField = field.getName();
        }
        String customField = entityInfo.getMappingColumnMap().get(field.getName());
        String string = realHighLightField = Objects.isNull(customField) ? field.getName() : customField;
        if (dbConfig.isMapUnderscoreToCamelCase()) {
            realHighLightField = StringUtils.camelToUnderline((String)realHighLightField);
        }
        entityInfo.getHighlightFieldMap().putIfAbsent(realHighLightField, mappingField);
        HighLightParam highLightParam = new HighLightParam();
        highLightParam.setFragmentSize(highLight.fragmentSize()).setPreTag(highLight.preTag()).setPostTag(highLight.postTag()).setHighLightField(realHighLightField).setHighLightType(highLight.highLightType());
        if (BaseEsConstants.MINUS_ONE.intValue() != highLight.numberOfFragments() && highLight.numberOfFragments() > BaseEsConstants.ZERO) {
            highLightParam.setNumberOfFragments(highLight.numberOfFragments());
        }
        entityInfo.getHighLightParams().add(highLightParam);
    }

    private static void processNested(Class<?> nestedClass, GlobalConfig.DbConfig dbConfig, EntityInfo entityInfo) {
        List<Field> allFields = EntityInfoHelper.getAllFields(nestedClass);
        HashMap mappingColumnMap = new HashMap(allFields.size());
        HashMap columnMappingMap = new HashMap(allFields.size());
        HashMap fieldTypeMap = new HashMap();
        ArrayList entityFieldInfoList = new ArrayList();
        HashSet notSerializedFields = new HashSet();
        allFields.forEach(field -> {
            FieldType fieldType;
            String mappingColumn;
            MultiIndexField multiIndexField = field.getAnnotation(MultiIndexField.class);
            IndexField indexField = Optional.ofNullable(multiIndexField).map(MultiIndexField::mainIndexField).orElse(field.getAnnotation(IndexField.class));
            if (Objects.isNull(indexField)) {
                mappingColumn = EntityInfoHelper.getMappingColumn(dbConfig, field);
                EntityFieldInfo entityFieldInfo = new EntityFieldInfo(dbConfig, (Field)field);
                entityFieldInfo.setMappingColumn(mappingColumn);
                fieldType = FieldType.getByType((String)IndexUtils.getEsFieldType(FieldType.NONE, field.getType().getSimpleName()));
                entityFieldInfo.setFieldType(fieldType);
                entityFieldInfo.setColumnType(field.getType().getSimpleName());
                entityFieldInfoList.add(entityFieldInfo);
            } else if (indexField.exist()) {
                if (DefaultNestedClass.class != indexField.nestedClass()) {
                    entityInfo.getPathClassMap().putIfAbsent(field.getName(), indexField.nestedClass());
                    EntityInfoHelper.processNested(indexField.nestedClass(), dbConfig, entityInfo);
                }
                mappingColumn = StringUtils.isNotBlank((CharSequence)indexField.value().trim()) ? indexField.value() : EntityInfoHelper.getMappingColumn(dbConfig, field);
                EntityFieldInfo entityFieldInfo = new EntityFieldInfo(dbConfig, (Field)field, indexField);
                fieldType = FieldType.NONE.equals((Object)indexField.fieldType()) ? FieldType.KEYWORD_TEXT : indexField.fieldType();
                entityFieldInfo.setMappingColumn(mappingColumn);
                entityFieldInfo.setFieldType(fieldType);
                entityFieldInfo.setFieldData(indexField.fieldData());
                entityFieldInfo.setColumnType(fieldType.getType());
                entityFieldInfo.setAnalyzer(indexField.analyzer());
                entityFieldInfo.setSearchAnalyzer(indexField.searchAnalyzer());
                if (FieldType.KEYWORD.equals((Object)fieldType)) {
                    entityFieldInfo.setIgnoreCase(indexField.ignoreCase());
                }
                if (StringUtils.isNotBlank((CharSequence)indexField.dateFormat())) {
                    entityFieldInfo.setDateFormat(indexField.dateFormat());
                }
                if (BaseEsConstants.MINUS_ONE.intValue() != indexField.scalingFactor()) {
                    entityFieldInfo.setScalingFactor(indexField.scalingFactor());
                }
                InnerIndexField[] innerIndexFields = Optional.ofNullable(multiIndexField).map(MultiIndexField::otherIndexFields).orElse(null);
                EntityInfoHelper.processInnerField(innerIndexFields, entityFieldInfo);
                entityFieldInfoList.add(entityFieldInfo);
            } else {
                mappingColumn = EntityInfoHelper.getMappingColumn(dbConfig, field);
                fieldType = FieldType.KEYWORD_TEXT;
                notSerializedFields.add(field.getName());
            }
            columnMappingMap.putIfAbsent(mappingColumn, field.getName());
            mappingColumnMap.putIfAbsent(field.getName(), mappingColumn);
            fieldTypeMap.putIfAbsent(field.getName(), fieldType.getType());
        });
        entityInfo.getNestedNotSerializeField().putIfAbsent(nestedClass, notSerializedFields);
        entityInfo.getNestedClassColumnMappingMap().putIfAbsent(nestedClass, columnMappingMap);
        entityInfo.getNestedClassMappingColumnMap().putIfAbsent(nestedClass, mappingColumnMap);
        entityInfo.getNestedClassFieldTypeMap().putIfAbsent(nestedClass, fieldTypeMap);
        entityInfo.getNestedFieldListMap().put(nestedClass, entityFieldInfoList);
    }

    private static void processInnerField(InnerIndexField[] innerIndexFields, EntityFieldInfo entityFieldInfo) {
        if (ArrayUtils.isNotEmpty((Object[])innerIndexFields)) {
            ArrayList<EntityFieldInfo.InnerFieldInfo> innerFieldInfoList = new ArrayList<EntityFieldInfo.InnerFieldInfo>();
            Arrays.stream(innerIndexFields).forEach(innerField -> {
                Assert.notBlank((String)innerField.suffix(), (String)"The Annotation MultiIndexField.InnerIndexField.value must has text");
                EntityFieldInfo.InnerFieldInfo innerFieldInfo = new EntityFieldInfo.InnerFieldInfo();
                innerFieldInfo.setColumn(innerField.suffix());
                innerFieldInfo.setFieldType(innerField.fieldType());
                innerFieldInfo.setAnalyzer(innerField.analyzer());
                innerFieldInfo.setSearchAnalyzer(innerField.searchAnalyzer());
                if (innerField.ignoreAbove() > BaseEsConstants.ZERO) {
                    innerFieldInfo.setIgnoreAbove(innerField.ignoreAbove());
                }
                innerFieldInfoList.add(innerFieldInfo);
            });
            entityFieldInfo.setInnerFieldInfoList(innerFieldInfoList);
        }
    }

    private static void initIndexFieldWithoutAnnotation(GlobalConfig.DbConfig dbConfig, List<EntityFieldInfo> fieldList, Field field, EntityInfo entityInfo) {
        boolean isNotSerializedField = entityInfo.getNotSerializeField().contains(field.getName());
        if (isNotSerializedField) {
            return;
        }
        EntityFieldInfo entityFieldInfo = new EntityFieldInfo(dbConfig, field);
        String mappingColumn = EntityInfoHelper.initMappingColumnMapAndGet(dbConfig, entityInfo, field);
        entityFieldInfo.setMappingColumn(mappingColumn);
        FieldType fieldType = FieldType.getByType((String)IndexUtils.getEsFieldType(FieldType.NONE, field.getType().getSimpleName()));
        entityInfo.getFieldTypeMap().putIfAbsent(field.getName(), fieldType.getType());
        entityFieldInfo.setColumnType(field.getType().getSimpleName());
        fieldList.add(entityFieldInfo);
    }

    private static boolean initIndexIdWithAnnotation(GlobalConfig.DbConfig dbConfig, EntityInfo entityInfo, Field field) {
        IndexId tableId = field.getAnnotation(IndexId.class);
        if (tableId != null) {
            if (IdType.NONE == tableId.type()) {
                entityInfo.setIdType(dbConfig.getIdType());
            } else {
                entityInfo.setIdType(tableId.type());
            }
            field.setAccessible(Boolean.TRUE);
            entityInfo.setClazz(field.getDeclaringClass()).setKeyField(field).setIdClass(field.getType()).setKeyProperty(field.getName());
            entityInfo.getNotSerializeField().add("id");
            entityInfo.getNotSerializeField().add(field.getName());
            entityInfo.getMappingColumnMap().putIfAbsent(field.getName(), "id");
            return true;
        }
        return false;
    }

    private static boolean initIndexIdWithoutAnnotation(GlobalConfig.DbConfig dbConfig, EntityInfo entityInfo, Field field) {
        String column = field.getName();
        if ("id".equalsIgnoreCase(column) || "_id".equals(column)) {
            field.setAccessible(Boolean.TRUE);
            entityInfo.setIdType(dbConfig.getIdType()).setKeyProperty(field.getName()).setKeyField(field).setIdClass(field.getType()).setClazz(field.getDeclaringClass());
            entityInfo.getNotSerializeField().add("id");
            entityInfo.getNotSerializeField().add(field.getName());
            entityInfo.getMappingColumnMap().putIfAbsent(field.getName(), "id");
            return true;
        }
        return false;
    }

    public static boolean isExistIndexId(List<Field> list) {
        for (Field field : list) {
            IndexId tableId = field.getAnnotation(IndexId.class);
            if (tableId == null) continue;
            return true;
        }
        return false;
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        return ReflectionKit.getFieldList((Class)ClassUtils.getUserClass(clazz));
    }

    private static void initIndexName(Class<?> clazz, GlobalConfig globalConfig, EntityInfo entityInfo) {
        String indexName;
        GlobalConfig.DbConfig dbConfig = globalConfig.getDbConfig();
        IndexName table = clazz.getAnnotation(IndexName.class);
        String tableName = clazz.getSimpleName().toLowerCase(Locale.ROOT);
        String tablePrefix = dbConfig.getIndexPrefix();
        boolean tablePrefixEffect = true;
        if (Objects.isNull(table)) {
            indexName = tableName;
        } else {
            if (StringUtils.isNotBlank((CharSequence)table.value())) {
                indexName = table.value();
                if (StringUtils.isNotBlank((CharSequence)tablePrefix) && !table.keepGlobalPrefix()) {
                    tablePrefixEffect = false;
                }
            } else {
                indexName = tableName;
            }
            if (StringUtils.isNotBlank((CharSequence)table.routing())) {
                entityInfo.setRouting(table.routing());
            }
            entityInfo.setMaxResultWindow(table.maxResultWindow());
            entityInfo.setAliasName(table.aliasName());
            entityInfo.setShardsNum(table.shardsNum());
            entityInfo.setReplicasNum(table.replicasNum());
            entityInfo.setChild(table.child());
            entityInfo.setChildClass(table.childClass());
            RefreshPolicy refreshPolicy = table.refreshPolicy();
            if (RefreshPolicy.GLOBAL.equals((Object)refreshPolicy)) {
                refreshPolicy = dbConfig.getRefreshPolicy();
            }
            entityInfo.setRefreshPolicy(refreshPolicy);
        }
        String targetIndexName = indexName;
        if (StringUtils.isNotBlank((CharSequence)tablePrefix) && tablePrefixEffect) {
            targetIndexName = tablePrefix + targetIndexName;
        }
        entityInfo.setIndexName(targetIndexName);
    }

    private static String initMappingColumnMapAndGet(GlobalConfig.DbConfig dbConfig, EntityInfo entityInfo, Field field) {
        String mappingColumn = EntityInfoHelper.getMappingColumn(dbConfig, field);
        entityInfo.getMappingColumnMap().putIfAbsent(field.getName(), mappingColumn);
        return mappingColumn;
    }

    private static String getMappingColumn(GlobalConfig.DbConfig dbConfig, Field field) {
        String mappingColumn = field.getName();
        if (dbConfig.isMapUnderscoreToCamelCase()) {
            mappingColumn = StringUtils.camelToUnderline((String)field.getName());
        }
        return mappingColumn;
    }
}

