/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.core.conditions.function;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.dromara.easyes.common.constants.BaseEsConstants;
import org.dromara.easyes.common.utils.CollectionUtils;
import org.dromara.easyes.common.utils.ExceptionUtils;
import org.dromara.easyes.core.toolkit.FieldUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.geometry.Geometry;

public interface Geo<Children, R>
extends Serializable {
    default public Children geoBoundingBox(R column, GeoPoint topLeft, GeoPoint bottomRight) {
        return this.geoBoundingBox(true, column, topLeft, bottomRight, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoBoundingBox(boolean condition, R column, GeoPoint topLeft, GeoPoint bottomRight) {
        return this.geoBoundingBox(condition, column, topLeft, bottomRight, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoBoundingBox(R column, GeoPoint topLeft, GeoPoint bottomRight, Float boost) {
        return this.geoBoundingBox(true, column, topLeft, bottomRight, boost);
    }

    default public Children geoBoundingBox(R column, String topLeft, String bottomRight) {
        GeoPoint topLeftGeoPoint = new GeoPoint(topLeft);
        GeoPoint bottomRightGeoPoint = new GeoPoint(bottomRight);
        return this.geoBoundingBox(true, column, topLeftGeoPoint, bottomRightGeoPoint, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoBoundingBox(boolean condition, R column, String topLeft, String bottomRight) {
        GeoPoint topLeftGeoPoint = new GeoPoint(topLeft);
        GeoPoint bottomRightGeoPoint = new GeoPoint(bottomRight);
        return this.geoBoundingBox(condition, column, topLeftGeoPoint, bottomRightGeoPoint, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoBoundingBox(R column, String topLeft, String bottomRight, Float boost) {
        GeoPoint topLeftGeoPoint = new GeoPoint(topLeft);
        GeoPoint bottomRightGeoPoint = new GeoPoint(bottomRight);
        return this.geoBoundingBox(true, column, topLeftGeoPoint, bottomRightGeoPoint, boost);
    }

    default public Children geoBoundingBox(String column, GeoPoint topLeft, GeoPoint bottomRight) {
        return this.geoBoundingBox(true, column, topLeft, bottomRight, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoBoundingBox(boolean condition, String column, GeoPoint topLeft, GeoPoint bottomRight) {
        return this.geoBoundingBox(condition, column, topLeft, bottomRight, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoBoundingBox(String column, GeoPoint topLeft, GeoPoint bottomRight, Float boost) {
        return this.geoBoundingBox(true, column, topLeft, bottomRight, boost);
    }

    default public Children geoBoundingBox(String column, String topLeft, String bottomRight) {
        GeoPoint topLeftGeoPoint = new GeoPoint(topLeft);
        GeoPoint bottomRightGeoPoint = new GeoPoint(bottomRight);
        return this.geoBoundingBox(true, column, topLeftGeoPoint, bottomRightGeoPoint, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoBoundingBox(boolean condition, String column, String topLeft, String bottomRight) {
        GeoPoint topLeftGeoPoint = new GeoPoint(topLeft);
        GeoPoint bottomRightGeoPoint = new GeoPoint(bottomRight);
        return this.geoBoundingBox(condition, column, topLeftGeoPoint, bottomRightGeoPoint, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoBoundingBox(String column, String topLeft, String bottomRight, Float boost) {
        GeoPoint topLeftGeoPoint = new GeoPoint(topLeft);
        GeoPoint bottomRightGeoPoint = new GeoPoint(bottomRight);
        return this.geoBoundingBox(true, column, topLeftGeoPoint, bottomRightGeoPoint, boost);
    }

    default public Children geoBoundingBox(boolean condition, R column, GeoPoint topLeft, GeoPoint bottomRight, Float boost) {
        return this.geoBoundingBox(condition, FieldUtils.getFieldName(column), topLeft, bottomRight, boost);
    }

    public Children geoBoundingBox(boolean var1, String var2, GeoPoint var3, GeoPoint var4, Float var5);

    default public Children geoDistance(R column, Double distance, GeoPoint centralGeoPoint) {
        return this.geoDistance(true, column, distance, DistanceUnit.KILOMETERS, centralGeoPoint, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoDistance(R column, Double distance, DistanceUnit distanceUnit, GeoPoint centralGeoPoint) {
        return this.geoDistance(true, column, distance, distanceUnit, centralGeoPoint, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoDistance(R column, Double distance, DistanceUnit distanceUnit, GeoPoint centralGeoPoint, Float boost) {
        return this.geoDistance(true, column, distance, distanceUnit, centralGeoPoint, boost);
    }

    default public Children geoDistance(R column, Double distance, DistanceUnit distanceUnit, String centralGeoPoint) {
        GeoPoint geoPoint = new GeoPoint(centralGeoPoint);
        return this.geoDistance(true, column, distance, distanceUnit, geoPoint, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoDistance(boolean condition, R column, Double distance, DistanceUnit distanceUnit, String centralGeoPoint) {
        GeoPoint geoPoint = new GeoPoint(centralGeoPoint);
        return this.geoDistance(condition, column, distance, distanceUnit, geoPoint, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoDistance(R column, Double distance, DistanceUnit distanceUnit, String centralGeoPoint, Float boost) {
        GeoPoint geoPoint = new GeoPoint(centralGeoPoint);
        return this.geoDistance(true, column, distance, distanceUnit, geoPoint, boost);
    }

    default public Children geoDistance(boolean condition, R column, Double distance, DistanceUnit distanceUnit, String centralGeoPoint, Float boost) {
        GeoPoint geoPoint = new GeoPoint(centralGeoPoint);
        return this.geoDistance(condition, column, distance, distanceUnit, geoPoint, boost);
    }

    default public Children geoDistance(String column, Double distance, GeoPoint centralGeoPoint) {
        return this.geoDistance(true, column, distance, DistanceUnit.KILOMETERS, centralGeoPoint, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoDistance(String column, Double distance, DistanceUnit distanceUnit, GeoPoint centralGeoPoint) {
        return this.geoDistance(true, column, distance, distanceUnit, centralGeoPoint, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoDistance(String column, Double distance, DistanceUnit distanceUnit, GeoPoint centralGeoPoint, Float boost) {
        return this.geoDistance(true, column, distance, distanceUnit, centralGeoPoint, boost);
    }

    default public Children geoDistance(String column, Double distance, DistanceUnit distanceUnit, String centralGeoPoint) {
        GeoPoint geoPoint = new GeoPoint(centralGeoPoint);
        return this.geoDistance(true, column, distance, distanceUnit, geoPoint, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoDistance(boolean condition, String column, Double distance, DistanceUnit distanceUnit, String centralGeoPoint) {
        GeoPoint geoPoint = new GeoPoint(centralGeoPoint);
        return this.geoDistance(condition, column, distance, distanceUnit, geoPoint, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoDistance(String column, Double distance, DistanceUnit distanceUnit, String centralGeoPoint, Float boost) {
        GeoPoint geoPoint = new GeoPoint(centralGeoPoint);
        return this.geoDistance(true, column, distance, distanceUnit, geoPoint, boost);
    }

    default public Children geoDistance(boolean condition, String column, Double distance, DistanceUnit distanceUnit, String centralGeoPoint, Float boost) {
        GeoPoint geoPoint = new GeoPoint(centralGeoPoint);
        return this.geoDistance(condition, column, distance, distanceUnit, geoPoint, boost);
    }

    default public Children geoDistance(boolean condition, R column, Double distance, DistanceUnit distanceUnit, GeoPoint centralGeoPoint, Float boost) {
        return this.geoDistance(condition, FieldUtils.getFieldName(column), distance, distanceUnit, centralGeoPoint, boost);
    }

    public Children geoDistance(boolean var1, String var2, Double var3, DistanceUnit var4, GeoPoint var5, Float var6);

    default public Children geoDistance(R column, String distance, GeoPoint centralGeoPoint) {
        return this.geoDistance(true, column, distance, centralGeoPoint, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoDistance(boolean condition, R column, String distance, GeoPoint centralGeoPoint) {
        return this.geoDistance(condition, column, distance, centralGeoPoint, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoDistance(R column, String distance, GeoPoint centralGeoPoint, Float boost) {
        return this.geoDistance(true, column, distance, centralGeoPoint, boost);
    }

    default public Children geoDistance(R column, String distance, String centralGeoPoint) {
        GeoPoint geoPoint = new GeoPoint(centralGeoPoint);
        return this.geoDistance(true, column, distance, geoPoint, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoDistance(boolean condition, R column, String distance, String centralGeoPoint) {
        GeoPoint geoPoint = new GeoPoint(centralGeoPoint);
        return this.geoDistance(condition, column, distance, geoPoint, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoDistance(R column, String distance, String centralGeoPoint, Float boost) {
        GeoPoint geoPoint = new GeoPoint(centralGeoPoint);
        return this.geoDistance(true, column, distance, geoPoint, boost);
    }

    default public Children geoDistance(boolean condition, R column, String distance, String centralGeoPoint, Float boost) {
        GeoPoint geoPoint = new GeoPoint(centralGeoPoint);
        return this.geoDistance(condition, column, distance, geoPoint, boost);
    }

    default public Children geoDistance(String column, String distance, GeoPoint centralGeoPoint) {
        return this.geoDistance(true, column, distance, centralGeoPoint, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoDistance(boolean condition, String column, String distance, GeoPoint centralGeoPoint) {
        return this.geoDistance(condition, column, distance, centralGeoPoint, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoDistance(String column, String distance, GeoPoint centralGeoPoint, Float boost) {
        return this.geoDistance(true, column, distance, centralGeoPoint, boost);
    }

    default public Children geoDistance(String column, String distance, String centralGeoPoint) {
        GeoPoint geoPoint = new GeoPoint(centralGeoPoint);
        return this.geoDistance(true, column, distance, geoPoint, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoDistance(boolean condition, String column, String distance, String centralGeoPoint) {
        GeoPoint geoPoint = new GeoPoint(centralGeoPoint);
        return this.geoDistance(condition, column, distance, geoPoint, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoDistance(String column, String distance, String centralGeoPoint, Float boost) {
        GeoPoint geoPoint = new GeoPoint(centralGeoPoint);
        return this.geoDistance(true, column, distance, geoPoint, boost);
    }

    default public Children geoDistance(boolean condition, String column, String distance, String centralGeoPoint, Float boost) {
        GeoPoint geoPoint = new GeoPoint(centralGeoPoint);
        return this.geoDistance(condition, column, distance, geoPoint, boost);
    }

    default public Children geoDistance(boolean condition, R column, String distance, GeoPoint centralGeoPoint, Float boost) {
        return this.geoDistance(condition, FieldUtils.getFieldName(column), distance, centralGeoPoint, boost);
    }

    public Children geoDistance(boolean var1, String var2, String var3, GeoPoint var4, Float var5);

    default public Children geoPolygon(R column, List<GeoPoint> geoPoints) {
        return this.geoPolygon(true, column, geoPoints, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoPolygon(boolean condition, R column, List<GeoPoint> geoPoints) {
        return this.geoPolygon(condition, column, geoPoints, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoPolygon(R column, List<GeoPoint> geoPoints, Float boost) {
        return this.geoPolygon(true, column, geoPoints, boost);
    }

    default public Children geoPolygonStr(R column, List<String> strPoints) {
        if (CollectionUtils.isEmpty(strPoints)) {
            throw ExceptionUtils.eee((String)"polygon point list must not be empty", (Object[])new Object[0]);
        }
        List<GeoPoint> geoPoints = strPoints.stream().map(GeoPoint::new).collect(Collectors.toList());
        return this.geoPolygon(true, column, geoPoints, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoPolygonStr(boolean condition, R column, List<String> strPoints) {
        if (CollectionUtils.isEmpty(strPoints)) {
            throw ExceptionUtils.eee((String)"polygon point list must not be empty", (Object[])new Object[0]);
        }
        List<GeoPoint> geoPoints = strPoints.stream().map(GeoPoint::new).collect(Collectors.toList());
        return this.geoPolygon(condition, column, geoPoints, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoPolygonStr(R column, List<String> strPoints, Float boost) {
        if (CollectionUtils.isEmpty(strPoints)) {
            throw ExceptionUtils.eee((String)"polygon point list must not be empty", (Object[])new Object[0]);
        }
        List<GeoPoint> geoPoints = strPoints.stream().map(GeoPoint::new).collect(Collectors.toList());
        return this.geoPolygon(true, column, geoPoints, boost);
    }

    default public Children geoPolygon(String column, List<GeoPoint> geoPoints) {
        return this.geoPolygon(true, column, geoPoints, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoPolygon(boolean condition, String column, List<GeoPoint> geoPoints) {
        return this.geoPolygon(condition, column, geoPoints, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoPolygon(String column, List<GeoPoint> geoPoints, Float boost) {
        return this.geoPolygon(true, column, geoPoints, boost);
    }

    default public Children geoPolygonStr(String column, List<String> strPoints) {
        if (CollectionUtils.isEmpty(strPoints)) {
            throw ExceptionUtils.eee((String)"polygon point list must not be empty", (Object[])new Object[0]);
        }
        List<GeoPoint> geoPoints = strPoints.stream().map(GeoPoint::new).collect(Collectors.toList());
        return this.geoPolygon(true, column, geoPoints, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoPolygonStr(boolean condition, String column, List<String> strPoints) {
        if (CollectionUtils.isEmpty(strPoints)) {
            throw ExceptionUtils.eee((String)"polygon point list must not be empty", (Object[])new Object[0]);
        }
        List<GeoPoint> geoPoints = strPoints.stream().map(GeoPoint::new).collect(Collectors.toList());
        return this.geoPolygon(condition, column, geoPoints, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoPolygonStr(String column, List<String> strPoints, Float boost) {
        if (CollectionUtils.isEmpty(strPoints)) {
            throw ExceptionUtils.eee((String)"polygon point list must not be empty", (Object[])new Object[0]);
        }
        List<GeoPoint> geoPoints = strPoints.stream().map(GeoPoint::new).collect(Collectors.toList());
        return this.geoPolygon(true, column, geoPoints, boost);
    }

    default public Children geoPolygon(boolean condition, R column, List<GeoPoint> geoPoints, Float boost) {
        return this.geoPolygon(condition, FieldUtils.getFieldName(column), geoPoints, boost);
    }

    public Children geoPolygon(boolean var1, String var2, List<GeoPoint> var3, Float var4);

    default public Children geoShape(R column, String indexedShapeId) {
        return this.geoShape(true, column, indexedShapeId, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoShape(R column, String indexedShapeId, Float boost) {
        return this.geoShape(true, column, indexedShapeId, boost);
    }

    default public Children geoShape(boolean condition, R column, String indexedShapeId) {
        return this.geoShape(condition, column, indexedShapeId, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoShape(String column, String indexedShapeId) {
        return this.geoShape(true, column, indexedShapeId, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoShape(String column, String indexedShapeId, Float boost) {
        return this.geoShape(true, column, indexedShapeId, boost);
    }

    default public Children geoShape(boolean condition, String column, String indexedShapeId) {
        return this.geoShape(condition, column, indexedShapeId, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoShape(boolean condition, R column, String indexedShapeId, Float boost) {
        return this.geoShape(condition, FieldUtils.getFieldName(column), indexedShapeId, boost);
    }

    public Children geoShape(boolean var1, String var2, String var3, Float var4);

    default public Children geoShape(R column, Geometry geometry) {
        return this.geoShape(true, column, geometry, ShapeRelation.WITHIN, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoShape(R column, Geometry geometry, ShapeRelation shapeRelation) {
        return this.geoShape(true, column, geometry, shapeRelation, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoShape(boolean condition, R column, Geometry geometry, ShapeRelation shapeRelation) {
        return this.geoShape(condition, column, geometry, shapeRelation, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoShape(R column, Geometry geometry, ShapeRelation shapeRelation, Float boost) {
        return this.geoShape(true, column, geometry, shapeRelation, boost);
    }

    default public Children geoShape(String column, Geometry geometry) {
        return this.geoShape(true, column, geometry, ShapeRelation.WITHIN, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoShape(String column, Geometry geometry, ShapeRelation shapeRelation) {
        return this.geoShape(true, column, geometry, shapeRelation, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoShape(boolean condition, String column, Geometry geometry, ShapeRelation shapeRelation) {
        return this.geoShape(condition, column, geometry, shapeRelation, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children geoShape(String column, Geometry geometry, ShapeRelation shapeRelation, Float boost) {
        return this.geoShape(true, column, geometry, shapeRelation, boost);
    }

    default public Children geoShape(boolean condition, R column, Geometry geometry, ShapeRelation shapeRelation, Float boost) {
        return this.geoShape(condition, FieldUtils.getFieldName(column), geometry, shapeRelation, boost);
    }

    public Children geoShape(boolean var1, String var2, Geometry var3, ShapeRelation var4, Float var5);
}

