/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.core.biz;

import java.util.Arrays;
import java.util.List;
import org.dromara.easyes.core.biz.PageSerializable;

public class EsPageInfo<T>
extends PageSerializable<T> {
    private int pageNum;
    private int pageSize;
    private int size;
    private int startRow;
    private int endRow;
    private int pages;
    private int prePage;
    private int nextPage;
    private boolean isFirstPage = false;
    private boolean isLastPage = false;
    private boolean hasPreviousPage = false;
    private boolean hasNextPage = false;
    private int navigatePages;
    private int[] navigatePageNums;
    private int navigateFirstPage;
    private int navigateLastPage;

    public EsPageInfo(List<T> list) {
        this(list, 8);
    }

    public EsPageInfo(List<T> list, int navigatePages) {
        super(list);
        this.pageNum = 1;
        this.pageSize = list.size();
        this.pages = this.pageSize > 0 ? 1 : 0;
        this.size = list.size();
        this.startRow = 0;
        this.endRow = list.size() > 0 ? list.size() - 1 : 0;
        this.navigatePages = navigatePages;
    }

    public static <T> EsPageInfo<T> of(List<T> list) {
        return new EsPageInfo<T>(list);
    }

    public static <T> EsPageInfo<T> of(List<T> list, int navigatePages) {
        return new EsPageInfo<T>(list, navigatePages);
    }

    public void calcNavigatePageNums() {
        if (this.pages <= this.navigatePages) {
            this.navigatePageNums = new int[this.pages];
            for (int i = 0; i < this.pages; ++i) {
                this.navigatePageNums[i] = i + 1;
            }
        } else {
            this.navigatePageNums = new int[this.navigatePages];
            int startNum = this.pageNum - this.navigatePages / 2;
            int endNum = this.pageNum + this.navigatePages / 2;
            if (startNum < 1) {
                startNum = 1;
                for (int i = 0; i < this.navigatePages; ++i) {
                    this.navigatePageNums[i] = startNum++;
                }
            } else if (endNum > this.pages) {
                endNum = this.pages;
                for (int i = this.navigatePages - 1; i >= 0; --i) {
                    this.navigatePageNums[i] = endNum--;
                }
            } else {
                for (int i = 0; i < this.navigatePages; ++i) {
                    this.navigatePageNums[i] = startNum++;
                }
            }
        }
    }

    public void calcPage() {
        if (this.navigatePageNums != null && this.navigatePageNums.length > 0) {
            this.navigateFirstPage = this.navigatePageNums[0];
            this.navigateLastPage = this.navigatePageNums[this.navigatePageNums.length - 1];
            if (this.pageNum > 1) {
                this.prePage = this.pageNum - 1;
            }
            if (this.pageNum < this.pages) {
                this.nextPage = this.pageNum + 1;
            }
        }
    }

    public void judgePageBoundary() {
        this.isFirstPage = this.pageNum == 1;
        this.isLastPage = this.pageNum == this.pages || this.pages == 0;
        this.hasPreviousPage = this.pageNum > 1;
        this.hasNextPage = this.pageNum < this.pages;
    }

    @Override
    public String toString() {
        return "PageInfo{pageNum=" + this.pageNum + ", pageSize=" + this.pageSize + ", size=" + this.size + ", startRow=" + this.startRow + ", endRow=" + this.endRow + ", pages=" + this.pages + ", prePage=" + this.prePage + ", nextPage=" + this.nextPage + ", isFirstPage=" + this.isFirstPage + ", isLastPage=" + this.isLastPage + ", hasPreviousPage=" + this.hasPreviousPage + ", hasNextPage=" + this.hasNextPage + ", navigatePages=" + this.navigatePages + ", navigatepageNums=" + Arrays.toString(this.navigatePageNums) + ", navigateFirstPage=" + this.navigateFirstPage + ", navigateLastPage=" + this.navigateLastPage + ", total=" + this.total + ", list=" + this.list + '}';
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getSize() {
        return this.size;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public int getPages() {
        return this.pages;
    }

    public int getPrePage() {
        return this.prePage;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public boolean isFirstPage() {
        return this.isFirstPage;
    }

    public boolean isLastPage() {
        return this.isLastPage;
    }

    public boolean isHasPreviousPage() {
        return this.hasPreviousPage;
    }

    public boolean isHasNextPage() {
        return this.hasNextPage;
    }

    public int getNavigatePages() {
        return this.navigatePages;
    }

    public int[] getNavigatePageNums() {
        return this.navigatePageNums;
    }

    public int getNavigateFirstPage() {
        return this.navigateFirstPage;
    }

    public int getNavigateLastPage() {
        return this.navigateLastPage;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public void setPrePage(int prePage) {
        this.prePage = prePage;
    }

    public void setNextPage(int nextPage) {
        this.nextPage = nextPage;
    }

    public void setFirstPage(boolean isFirstPage) {
        this.isFirstPage = isFirstPage;
    }

    public void setLastPage(boolean isLastPage) {
        this.isLastPage = isLastPage;
    }

    public void setHasPreviousPage(boolean hasPreviousPage) {
        this.hasPreviousPage = hasPreviousPage;
    }

    public void setHasNextPage(boolean hasNextPage) {
        this.hasNextPage = hasNextPage;
    }

    public void setNavigatePages(int navigatePages) {
        this.navigatePages = navigatePages;
    }

    public void setNavigatePageNums(int[] navigatePageNums) {
        this.navigatePageNums = navigatePageNums;
    }

    public void setNavigateFirstPage(int navigateFirstPage) {
        this.navigateFirstPage = navigateFirstPage;
    }

    public void setNavigateLastPage(int navigateLastPage) {
        this.navigateLastPage = navigateLastPage;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EsPageInfo)) {
            return false;
        }
        EsPageInfo other = (EsPageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageNum() != other.getPageNum()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getStartRow() != other.getStartRow()) {
            return false;
        }
        if (this.getEndRow() != other.getEndRow()) {
            return false;
        }
        if (this.getPages() != other.getPages()) {
            return false;
        }
        if (this.getPrePage() != other.getPrePage()) {
            return false;
        }
        if (this.getNextPage() != other.getNextPage()) {
            return false;
        }
        if (this.isFirstPage() != other.isFirstPage()) {
            return false;
        }
        if (this.isLastPage() != other.isLastPage()) {
            return false;
        }
        if (this.isHasPreviousPage() != other.isHasPreviousPage()) {
            return false;
        }
        if (this.isHasNextPage() != other.isHasNextPage()) {
            return false;
        }
        if (this.getNavigatePages() != other.getNavigatePages()) {
            return false;
        }
        if (this.getNavigateFirstPage() != other.getNavigateFirstPage()) {
            return false;
        }
        if (this.getNavigateLastPage() != other.getNavigateLastPage()) {
            return false;
        }
        return Arrays.equals(this.getNavigatePageNums(), other.getNavigatePageNums());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EsPageInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageNum();
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getSize();
        result = result * 59 + this.getStartRow();
        result = result * 59 + this.getEndRow();
        result = result * 59 + this.getPages();
        result = result * 59 + this.getPrePage();
        result = result * 59 + this.getNextPage();
        result = result * 59 + (this.isFirstPage() ? 79 : 97);
        result = result * 59 + (this.isLastPage() ? 79 : 97);
        result = result * 59 + (this.isHasPreviousPage() ? 79 : 97);
        result = result * 59 + (this.isHasNextPage() ? 79 : 97);
        result = result * 59 + this.getNavigatePages();
        result = result * 59 + this.getNavigateFirstPage();
        result = result * 59 + this.getNavigateLastPage();
        result = result * 59 + Arrays.hashCode(this.getNavigatePageNums());
        return result;
    }

    public EsPageInfo() {
    }
}

