/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.event.ScriptSessionEvent;
import org.directwebremoting.event.ScriptSessionListener;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.impl.DefaultScriptSession;
import org.directwebremoting.util.IdGenerator;
import org.directwebremoting.util.SharedObjects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptSessionManager
implements ScriptSessionManager {
    public static final String ATTRIBUTE_HTTPSESSIONID = "org.directwebremoting.ScriptSession.HttpSessionId";
    public static final String ATTRIBUTE_PAGE = "org.directwebremoting.ScriptSession.Page";
    protected EventListenerList scriptSessionListeners = new EventListenerList();
    private static IdGenerator generator = new IdGenerator();
    protected static final long DEFAULT_SESSION_CHECK_TIME = 30000L;
    protected PageNormalizer pageNormalizer;
    private long scriptSessionTimeout = 300000L;
    protected long scriptSessionCheckTime = 30000L;
    protected long lastSessionCheckAt = System.currentTimeMillis();
    protected final Object sessionLock = new Object();
    private Map<String, Set<String>> sessionXRef = new HashMap<String, Set<String>>();
    private Map<String, DefaultScriptSession> sessionMap = new HashMap<String, DefaultScriptSession>();
    private Map<String, Set<RealScriptSession>> pageSessionMap = new HashMap<String, Set<RealScriptSession>>();
    private static final Log log = LogFactory.getLog(DefaultScriptSessionManager.class);

    public DefaultScriptSessionManager() {
        Runnable runnable = new Runnable(){

            public void run() {
                DefaultScriptSessionManager.this.maybeCheckTimeouts();
            }
        };
        ScheduledThreadPoolExecutor executor = SharedObjects.getScheduledThreadPoolExecutor();
        executor.schedule(runnable, 60L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RealScriptSession getScriptSession(String id, String page, String httpSessionId) {
        DefaultScriptSession scriptSession;
        this.maybeCheckTimeouts();
        Object object = this.sessionLock;
        synchronized (object) {
            scriptSession = this.sessionMap.get(id);
            if (scriptSession == null) {
                return null;
            }
            this.associateScriptSessionAndPage(scriptSession, page);
            this.associateScriptSessionAndHttpSession(scriptSession, httpSessionId);
        }
        return scriptSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RealScriptSession createScriptSession(String page, String httpSessionId) {
        String id = generator.generateId(16);
        DefaultScriptSession scriptSession = new DefaultScriptSession(id, this, page, httpSessionId);
        Object object = this.sessionLock;
        synchronized (object) {
            this.sessionMap.put(id, scriptSession);
            this.associateScriptSessionAndPage(scriptSession, page);
            this.associateScriptSessionAndHttpSession(scriptSession, httpSessionId);
        }
        this.fireScriptSessionCreatedEvent(scriptSession);
        return scriptSession;
    }

    protected void associateScriptSessionAndHttpSession(RealScriptSession scriptSession, String httpSessionId) {
        scriptSession.setAttribute(ATTRIBUTE_HTTPSESSIONID, httpSessionId);
        Set<String> scriptSessionIds = this.sessionXRef.get(httpSessionId);
        if (scriptSessionIds == null) {
            scriptSessionIds = new HashSet<String>();
            this.sessionXRef.put(httpSessionId, scriptSessionIds);
        }
        scriptSessionIds.add(scriptSession.getId());
    }

    protected void disassociateScriptSessionAndHttpSession(RealScriptSession scriptSession) {
        Object httpSessionId = scriptSession.getAttribute(ATTRIBUTE_HTTPSESSIONID);
        if (httpSessionId == null) {
            return;
        }
        Set<String> scriptSessionIds = this.sessionXRef.get(httpSessionId);
        if (scriptSessionIds == null) {
            log.debug((Object)"Warning: No script session ids for http session");
            return;
        }
        scriptSessionIds.remove(scriptSession.getId());
        if (scriptSessionIds.size() == 0) {
            this.sessionXRef.remove(httpSessionId);
        }
        scriptSession.setAttribute(ATTRIBUTE_HTTPSESSIONID, null);
    }

    protected void associateScriptSessionAndPage(RealScriptSession scriptSession, String page) {
        if (page == null) {
            return;
        }
        String normalizedPage = this.pageNormalizer.normalizePage(page);
        Set<RealScriptSession> pageSessions = this.pageSessionMap.get(normalizedPage);
        if (pageSessions == null) {
            pageSessions = new HashSet<RealScriptSession>();
            this.pageSessionMap.put(normalizedPage, pageSessions);
        }
        pageSessions.add(scriptSession);
        scriptSession.setAttribute(ATTRIBUTE_PAGE, normalizedPage);
    }

    protected void disassociateScriptSessionAndPage(RealScriptSession scriptSession) {
        for (Set<RealScriptSession> pageSessions : this.pageSessionMap.values()) {
            pageSessions.remove(scriptSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ScriptSession> getScriptSessionsByPage(String url) {
        String normalizedPage = this.pageNormalizer.normalizePage(url);
        Object object = this.sessionLock;
        synchronized (object) {
            Set<RealScriptSession> pageSessions = this.pageSessionMap.get(normalizedPage);
            if (pageSessions == null) {
                pageSessions = new HashSet<RealScriptSession>();
            }
            HashSet<ScriptSession> reply = new HashSet<ScriptSession>();
            reply.addAll(pageSessions);
            return reply;
        }
    }

    public Collection<RealScriptSession> getScriptSessionsByHttpSessionId(String httpSessionId) {
        ArrayList<RealScriptSession> reply = new ArrayList<RealScriptSession>();
        Set<String> scriptSessionIds = this.sessionXRef.get(httpSessionId);
        for (String scriptSessionId : scriptSessionIds) {
            DefaultScriptSession scriptSession = this.sessionMap.get(scriptSessionId);
            if (scriptSession == null) continue;
            reply.add(scriptSession);
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ScriptSession> getAllScriptSessions() {
        Object object = this.sessionLock;
        synchronized (object) {
            HashSet<ScriptSession> reply = new HashSet<ScriptSession>();
            reply.addAll(this.sessionMap.values());
            return reply;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidate(RealScriptSession scriptSession) {
        Object object = this.sessionLock;
        synchronized (object) {
            this.sessionMap.remove(scriptSession.getId());
            this.disassociateScriptSessionAndPage(scriptSession);
            this.disassociateScriptSessionAndHttpSession(scriptSession);
        }
        this.fireScriptSessionDestroyedEvent(scriptSession);
    }

    protected void maybeCheckTimeouts() {
        long now = System.currentTimeMillis();
        if (now - this.scriptSessionCheckTime > this.lastSessionCheckAt) {
            this.checkTimeouts();
            this.lastSessionCheckAt = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        long now = System.currentTimeMillis();
        ArrayList<DefaultScriptSession> timeouts = new ArrayList<DefaultScriptSession>();
        Object object = this.sessionLock;
        synchronized (object) {
            for (DefaultScriptSession defaultScriptSession : this.sessionMap.values()) {
                long age;
                if (defaultScriptSession.isInvalidated() || (age = now - defaultScriptSession.getLastAccessedTime()) <= this.scriptSessionTimeout) continue;
                timeouts.add(defaultScriptSession);
            }
            for (ScriptSession scriptSession : timeouts) {
                DefaultScriptSession session = (DefaultScriptSession)scriptSession;
                session.invalidate();
            }
        }
    }

    @Override
    public long getScriptSessionTimeout() {
        return this.scriptSessionTimeout;
    }

    public void setScriptSessionTimeout(long scriptSessionTimeout) {
        this.scriptSessionTimeout = scriptSessionTimeout;
    }

    @Override
    public void addScriptSessionListener(ScriptSessionListener li) {
        this.scriptSessionListeners.add(ScriptSessionListener.class, li);
    }

    @Override
    public void removeScriptSessionListener(ScriptSessionListener li) {
        this.scriptSessionListeners.remove(ScriptSessionListener.class, li);
    }

    public void setPageNormalizer(PageNormalizer pageNormalizer) {
        this.pageNormalizer = pageNormalizer;
    }

    public void setScriptSessionCheckTime(long scriptSessionCheckTime) {
        this.scriptSessionCheckTime = scriptSessionCheckTime;
    }

    protected void fireScriptSessionCreatedEvent(ScriptSession scriptSession) {
        ScriptSessionEvent ev = new ScriptSessionEvent(scriptSession);
        Object[] listeners = this.scriptSessionListeners.getListenerList();
        for (int i = 0; i < listeners.length - 2; i += 2) {
            if (listeners[i] != ScriptSessionListener.class) continue;
            ((ScriptSessionListener)listeners[i + 1]).sessionCreated(ev);
        }
    }

    protected void fireScriptSessionDestroyedEvent(ScriptSession scriptSession) {
        ScriptSessionEvent ev = new ScriptSessionEvent(scriptSession);
        Object[] listeners = this.scriptSessionListeners.getListenerList();
        for (int i = 0; i < listeners.length - 2; i += 2) {
            if (listeners[i] != ScriptSessionListener.class) continue;
            ((ScriptSessionListener)listeners[i + 1]).sessionDestroyed(ev);
        }
    }
}

