/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.proxy.ScriptProxy;
import org.directwebremoting.util.JavascriptUtil;

public class EnginePrivate
extends ScriptProxy {
    private static final Log log = LogFactory.getLog(EnginePrivate.class);

    public static void remoteHandleCallback(ScriptConduit conduit, String batchId, String callId, Object data) throws IOException, MarshallException {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("dwr.engine.remote.handleCallback", batchId, callId, data);
        conduit.addScript(script);
    }

    public static void remoteHandleException(ScriptConduit conduit, String batchId, String callId, Throwable ex) throws IOException {
        try {
            ScriptBuffer script = new ScriptBuffer();
            script.appendCall("dwr.engine.remote.handleException", batchId, callId, ex);
            conduit.addScript(script);
        }
        catch (MarshallException mex) {
            log.warn((Object)"This exception can't happen. Really.", ex);
        }
    }

    public static void remoteHandleNewScriptSession(ScriptSession session, String newSessionId) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("dwr.engine.remote.handleNewScriptSession", newSessionId);
        session.addScript(script);
    }

    public static void remoteHandleNewWindowName(ScriptSession session, String windowName) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("dwr.engine.remote.handleNewWindowName", windowName);
        session.addScript(script);
    }

    public static String getRemoteHandleBatchExceptionScript(String batchId, Exception ex) {
        StringBuffer reply = new StringBuffer();
        String output = JavascriptUtil.escapeJavaScript(ex.getMessage());
        String params = "{ name:'" + ex.getClass().getName() + "', message:'" + output + "' }";
        if (batchId != null) {
            params = params + ", '" + batchId + "'";
        }
        reply.append("//#DWR-REPLY").append("\r\n");
        reply.append("if (window.dwr) dwr.engine.remote.handleBatchException(").append(params).append(");\r\n");
        reply.append("else if (window.parent.dwr) window.parent.dwr.engine.remote.handleBatchException(").append(params).append(");\r\n");
        return reply.toString();
    }

    public static String getRemotePollCometDisabledScript(String batchId) {
        StringBuffer reply = new StringBuffer();
        String params = "{ name:'dwr.engine.pollAndCometDisabled', message:'Polling and Comet are disabled. See the server logs.' }";
        if (batchId != null) {
            params = params + ", '" + batchId + "'";
        }
        reply.append("//#DWR-REPLY").append("\r\n");
        reply.append("if (window.dwr) dwr.engine.remote.pollCometDisabled(").append(params).append(");\r\n");
        reply.append("else if (window.parent.dwr) window.parent.dwr.engine.remote.pollCometDisabled(").append(params).append(");\r\n");
        return reply.toString();
    }

    public static String xmlStringToJavascriptDom(String xml) {
        String xmlout = JavascriptUtil.escapeJavaScript(xml);
        return "dwr.engine.serialize.toDom(\"" + xmlout + "\")";
    }

    public static String getEngineInitScript() {
        return "// Provide a default path to dwr.engine\nif (typeof this['dwr'] == 'undefined') this.dwr = {};\nif (typeof dwr['engine'] == 'undefined') dwr.engine = {};\n\n";
    }

    public static String getExecuteFunctionName() {
        return "dwr.engine._execute";
    }

    public static String remoteBeginIFrameResponse(String batchId, boolean useWindowParent) {
        String script = "dwr.engine.transport.iframe.remote.beginIFrameResponse(this.frameElement" + (batchId == null ? "" : ", '" + batchId + "'") + ");";
        if (useWindowParent) {
            script = EnginePrivate.addWindowParent(script);
        }
        return script;
    }

    public static String remoteEndIFrameResponse(String batchId, boolean useWindowParent) {
        String script = "dwr.engine.transport.iframe.remote.endIFrameResponse(" + (batchId == null ? "" : "'" + batchId + "'") + ");";
        if (useWindowParent) {
            script = EnginePrivate.addWindowParent(script);
        }
        return script;
    }

    public static String remoteEval(String script) {
        String script2 = "dwr.engine._eval(\"" + JavascriptUtil.escapeJavaScript(script) + "\");";
        return EnginePrivate.addWindowParent(script2);
    }

    public static ScriptBuffer createForeignWindowProxy(String windowName, ScriptBuffer original) {
        String proxy = JavascriptUtil.escapeJavaScript(original.toString());
        ScriptBuffer reply = new ScriptBuffer();
        reply.appendCall("dwr.engine.remote.handleForeign", windowName, proxy);
        reply.appendData(proxy);
        return reply;
    }

    private static String addWindowParent(String script) {
        return "try { window.parent." + script + " } catch(ex) { if (!(ex.number && ex.number == -2146823277)) { throw ex; }}";
    }
}

