/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.event;

import java.util.EventObject;
import org.directwebremoting.Hub;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.TypeHintContext;
import org.directwebremoting.io.RawData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageEvent
extends EventObject {
    private Hub hub;
    private Object data;
    private RawData rawData;
    private Source source;
    private ConverterManager converterManager;

    public MessageEvent(Hub hub, Object data) {
        super(hub);
        this.hub = hub;
        this.data = data;
        this.source = Source.SERVER;
    }

    public MessageEvent(Hub hub, ConverterManager converterManager, RawData rawData) {
        super(hub);
        this.hub = hub;
        this.converterManager = converterManager;
        this.rawData = rawData;
        this.source = Source.INTERNET;
    }

    public Hub getHub() {
        return this.hub;
    }

    public <T> T getData(Class<T> asType) throws MarshallException {
        if (this.source == Source.SERVER) {
            try {
                return (T)this.data;
            }
            catch (ClassCastException ex) {
                throw new MarshallException(asType, (Throwable)ex);
            }
        }
        InboundContext context = this.rawData.getInboundContext();
        InboundVariable inboundVariable = this.rawData.getInboundVariable();
        TypeHintContext typeHintContext = null;
        return (T)this.converterManager.convertInbound(asType, inboundVariable, context, typeHintContext);
    }

    public Object getRawData() {
        if (this.source == Source.SERVER) {
            return this.data;
        }
        return this.rawData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Source {
        SERVER,
        INTERNET;

    }
}

