/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.BitSet;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.statement.IPreparedBatchStatement;
import org.dbunit.database.statement.SimplePreparedStatement;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoPrimaryKeyException;
import org.dbunit.dataset.RowOutOfBoundsException;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.operation.AbstractBatchOperation;
import org.dbunit.operation.AbstractOperation;
import org.dbunit.operation.DatabaseOperation;
import org.dbunit.operation.InsertOperation;
import org.dbunit.operation.OperationData;
import org.dbunit.operation.UpdateOperation;

public class RefreshOperation
extends AbstractOperation {
    private final InsertOperation _insertOperation = (InsertOperation)DatabaseOperation.INSERT;
    private final UpdateOperation _updateOperation = (UpdateOperation)DatabaseOperation.UPDATE;

    RefreshOperation() {
    }

    private boolean isEmpty(ITable table) throws DataSetException {
        return AbstractBatchOperation.isEmpty(table);
    }

    public void execute(IDatabaseConnection connection, IDataSet dataSet) throws DatabaseUnitException, SQLException {
        ITableIterator iterator = dataSet.iterator();
        while (iterator.next()) {
            Object var10_10;
            ITable table = iterator.getTable();
            if (this.isEmpty(table)) continue;
            ITableMetaData metaData = AbstractOperation.getOperationMetaData(connection, table.getTableMetaData());
            RowOperation updateRowOperation = this.createUpdateOperation(connection, metaData);
            InsertRowOperation insertRowOperation = new InsertRowOperation(connection, metaData);
            try {
                try {
                    int i = 0;
                    while (true) {
                        if (!updateRowOperation.execute(table, i)) {
                            ((RowOperation)insertRowOperation).execute(table, i);
                        }
                        ++i;
                    }
                }
                catch (RowOutOfBoundsException e) {
                    var10_10 = null;
                    updateRowOperation.close();
                    insertRowOperation.close();
                }
            }
            catch (Throwable throwable) {
                var10_10 = null;
                updateRowOperation.close();
                insertRowOperation.close();
                throw throwable;
            }
        }
    }

    private RowOperation createUpdateOperation(IDatabaseConnection connection, ITableMetaData metaData) throws DataSetException, SQLException {
        if (metaData.getColumns().length > metaData.getPrimaryKeys().length) {
            return new UpdateRowOperation(connection, metaData);
        }
        return new RowExistOperation(connection, metaData);
    }

    private class RowExistOperation
    extends RowOperation {
        PreparedStatement _countStatement;

        public RowExistOperation(IDatabaseConnection connection, ITableMetaData metaData) throws DataSetException, SQLException {
            this._operationData = this.getSelectCountData(metaData, connection);
            this._countStatement = connection.getConnection().prepareStatement(this._operationData.getSql());
        }

        private OperationData getSelectCountData(ITableMetaData metaData, IDatabaseConnection connection) throws DataSetException {
            Column[] primaryKeys = metaData.getPrimaryKeys();
            if (primaryKeys.length == 0) {
                throw new NoPrimaryKeyException(metaData.getTableName());
            }
            StringBuffer sqlBuffer = new StringBuffer(128);
            sqlBuffer.append("select COUNT(*) from ");
            sqlBuffer.append(RefreshOperation.this.getQualifiedName(connection.getSchema(), metaData.getTableName(), connection));
            sqlBuffer.append(" where ");
            int i = 0;
            while (i < primaryKeys.length) {
                Column column = primaryKeys[i];
                if (i > 0) {
                    sqlBuffer.append(" and ");
                }
                sqlBuffer.append(column.getColumnName());
                sqlBuffer.append(" = ?");
                ++i;
            }
            return new OperationData(sqlBuffer.toString(), primaryKeys);
        }

        public boolean execute(ITable table, int row) throws DataSetException, SQLException {
            boolean bl;
            Column[] columns = this._operationData.getColumns();
            int i = 0;
            while (i < columns.length) {
                Object value = table.getValue(row, columns[i].getColumnName());
                DataType dataType = columns[i].getDataType();
                dataType.setSqlValue(value, i + 1, this._countStatement);
                ++i;
            }
            ResultSet resultSet = this._countStatement.executeQuery();
            try {
                resultSet.next();
                bl = resultSet.getInt(1) > 0;
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            return bl;
        }

        public void close() throws SQLException {
            this._countStatement.close();
        }
    }

    private class UpdateRowOperation
    extends RowOperation {
        PreparedStatement _countStatement;

        public UpdateRowOperation(IDatabaseConnection connection, ITableMetaData metaData) throws DataSetException, SQLException {
            this._operationData = RefreshOperation.this._updateOperation.getOperationData(metaData, null, connection);
            this._statement = new SimplePreparedStatement(this._operationData.getSql(), connection.getConnection());
        }
    }

    private class InsertRowOperation
    extends RowOperation {
        private IDatabaseConnection _connection;
        private ITableMetaData _metaData;

        public InsertRowOperation(IDatabaseConnection connection, ITableMetaData metaData) throws DataSetException, SQLException {
            this._connection = connection;
            this._metaData = metaData;
        }

        public boolean execute(ITable table, int row) throws DataSetException, SQLException {
            if (this._ignoreMapping == null || !RefreshOperation.this._insertOperation.equalsIgnoreMapping(this._ignoreMapping, table, row)) {
                if (this._statement != null) {
                    this._statement.close();
                }
                this._ignoreMapping = RefreshOperation.this._insertOperation.getIgnoreMapping(table, row);
                this._operationData = RefreshOperation.this._insertOperation.getOperationData(this._metaData, this._ignoreMapping, this._connection);
                this._statement = new SimplePreparedStatement(this._operationData.getSql(), this._connection.getConnection());
            }
            return super.execute(table, row);
        }
    }

    class RowOperation {
        protected IPreparedBatchStatement _statement;
        protected OperationData _operationData;
        protected BitSet _ignoreMapping;

        RowOperation() {
        }

        public boolean execute(ITable table, int row) throws DataSetException, SQLException {
            Column[] columns = this._operationData.getColumns();
            int i = 0;
            while (i < columns.length) {
                if (this._ignoreMapping == null || !this._ignoreMapping.get(i)) {
                    Object value = table.getValue(row, columns[i].getColumnName());
                    this._statement.addValue(value, columns[i].getDataType());
                }
                ++i;
            }
            this._statement.addBatch();
            int result = this._statement.executeBatch();
            this._statement.clearBatch();
            return result == 1;
        }

        public void close() throws SQLException {
            if (this._statement != null) {
                this._statement.close();
            }
        }
    }
}

