/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.ArrayList;
import org.dbunit.dataset.AbstractTableMetaData;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.filter.IColumnFilter;

public class FilteredTableMetaData
extends AbstractTableMetaData {
    private final String _tableName;
    private final Column[] _columns;
    private final Column[] _primaryKeys;

    public FilteredTableMetaData(ITableMetaData metaData, IColumnFilter columnFilter) throws DataSetException {
        this._tableName = metaData.getTableName();
        this._columns = FilteredTableMetaData.getFilteredColumns(this._tableName, metaData.getColumns(), columnFilter);
        this._primaryKeys = FilteredTableMetaData.getFilteredColumns(this._tableName, metaData.getPrimaryKeys(), columnFilter);
    }

    public static Column[] getFilteredColumns(String tableName, Column[] columns, IColumnFilter columnFilter) {
        if (columns == null) {
            return new Column[0];
        }
        ArrayList<Column> columnList = new ArrayList<Column>();
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (columnFilter.accept(tableName, column)) {
                columnList.add(column);
            }
            ++i;
        }
        return columnList.toArray(new Column[0]);
    }

    public String getTableName() {
        return this._tableName;
    }

    public Column[] getColumns() throws DataSetException {
        return this._columns;
    }

    public Column[] getPrimaryKeys() throws DataSetException {
        return this._primaryKeys;
    }
}

