/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.dbunit.database.CachedResultSetTable;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseDataSet;
import org.dbunit.database.DatabaseTableMetaData;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.statement.IStatementFactory;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.IDataTypeFactory;

public abstract class AbstractDatabaseConnection
implements IDatabaseConnection {
    private IDataSet _dataSet = null;
    private DatabaseConfig _databaseConfig = new DatabaseConfig();

    public IDataSet createDataSet() throws SQLException {
        if (this._dataSet == null) {
            this._dataSet = new DatabaseDataSet(this);
        }
        return this._dataSet;
    }

    public IDataSet createDataSet(String[] tableNames) throws SQLException {
        return new FilteredDataSet(tableNames, this.createDataSet());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ITable createQueryTable(String resultName, String sql) throws DataSetException, SQLException {
        CachedResultSetTable cachedResultSetTable;
        Statement statement = this.getConnection().createStatement();
        try {
            ResultSet resultSet = statement.executeQuery(sql);
            try {
                IDataTypeFactory typeFactory = (IDataTypeFactory)this._databaseConfig.getProperty("http://www.dbunit.org/properties/datatypeFactory");
                ITableMetaData metaData = DatabaseTableMetaData.createMetaData(resultName, resultSet, typeFactory);
                cachedResultSetTable = new CachedResultSetTable(metaData, resultSet);
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            statement.close();
            throw throwable;
        }
        statement.close();
        return cachedResultSetTable;
    }

    public int getRowCount(String tableName) throws SQLException {
        return this.getRowCount(tableName, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getRowCount(String tableName, String whereClause) throws SQLException {
        int n;
        StringBuffer sqlBuffer = new StringBuffer(128);
        sqlBuffer.append("select count(*) from ");
        sqlBuffer.append(tableName);
        if (whereClause != null) {
            sqlBuffer.append(" ");
            sqlBuffer.append(whereClause);
        }
        Statement statement = this.getConnection().createStatement();
        try {
            ResultSet resultSet = statement.executeQuery(sqlBuffer.toString());
            try {
                resultSet.next();
                n = resultSet.getInt(1);
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            statement.close();
            throw throwable;
        }
        statement.close();
        return n;
    }

    public DatabaseConfig getConfig() {
        return this._databaseConfig;
    }

    public IStatementFactory getStatementFactory() {
        return (IStatementFactory)this._databaseConfig.getProperty("http://www.dbunit.org/properties/statementFactory");
    }

    public abstract void close() throws SQLException;

    public abstract String getSchema();

    public abstract Connection getConnection() throws SQLException;
}

