/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata.xml;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.datanucleus.ClassConstants;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.xml.AbstractMetaDataHandler;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.util.EntityResolverFactory;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MetaDataParser
extends DefaultHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected final MetaDataManager mgr;
    protected final PluginManager pluginMgr;
    protected final boolean validate;
    SAXParser parser = null;

    public MetaDataParser(MetaDataManager mgr, PluginManager pluginMgr, boolean validate) {
        this.mgr = mgr;
        this.pluginMgr = pluginMgr;
        this.validate = validate;
    }

    public MetaData parseMetaDataURL(URL url, String handlerName) {
        if (url == null) {
            String msg = LOCALISER.msg("044031");
            NucleusLogger.METADATA.error(msg);
            throw new NucleusException(msg);
        }
        InputStream in = null;
        try {
            in = url.openStream();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (in == null) {
            try {
                in = new FileInputStream(StringUtils.getFileForFilename(url.getFile()));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (in == null) {
            NucleusLogger.METADATA.error(LOCALISER.msg("044032", (Object)url.toString()));
            throw new NucleusException(LOCALISER.msg("044032", (Object)url.toString()));
        }
        return this.parseMetaDataStream(in, url.toString(), handlerName);
    }

    public MetaData parseMetaDataFile(String fileName, String handlerName) {
        InputStream in = null;
        try {
            in = new URL(fileName).openStream();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (in == null) {
            try {
                in = new FileInputStream(StringUtils.getFileForFilename(fileName));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (in == null) {
            NucleusLogger.METADATA.error(LOCALISER.msg("044032", (Object)fileName));
            throw new NucleusException(LOCALISER.msg("044032", (Object)fileName));
        }
        return this.parseMetaDataStream(in, fileName, handlerName);
    }

    public synchronized MetaData parseMetaDataStream(InputStream in, String filename, String handlerName) {
        if (in == null) {
            throw new NullPointerException("input stream is null");
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044030", (Object)filename, (Object)handlerName, (Object)(this.validate ? "true" : "false")));
        }
        try {
            if (this.parser == null) {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(this.validate);
                factory.setNamespaceAware(this.validate);
                if (this.validate) {
                    try {
                        Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(this.getRegisteredSchemas(this.pluginMgr));
                        if (schema != null) {
                            try {
                                factory.setSchema(schema);
                            }
                            catch (UnsupportedOperationException e) {
                                NucleusLogger.METADATA.info(e.getMessage());
                            }
                        }
                    }
                    catch (Exception e) {
                        NucleusLogger.METADATA.info(e.getMessage());
                    }
                    try {
                        factory.setFeature("http://apache.org/xml/features/validation/schema", true);
                    }
                    catch (Exception e) {
                        NucleusLogger.METADATA.info(e.getMessage());
                    }
                }
                this.parser = factory.newSAXParser();
            }
            DefaultHandler handler = null;
            EntityResolver entityResolver = null;
            try {
                Object[] argValues;
                Class[] argTypes;
                entityResolver = EntityResolverFactory.getInstance(this.pluginMgr, handlerName);
                if (entityResolver != null) {
                    this.parser.getXMLReader().setEntityResolver(entityResolver);
                }
                if ((handler = (DefaultHandler)this.pluginMgr.createExecutableExtension("org.datanucleus.metadata_handler", "name", handlerName, "class-name", argTypes = new Class[]{ClassConstants.METADATA_MANAGER, String.class, EntityResolver.class}, argValues = new Object[]{this.mgr, filename, entityResolver})) == null) {
                    throw new NucleusUserException(LOCALISER.msg("044028", (Object)handlerName)).setFatal();
                }
            }
            catch (Exception e) {
                String msg = LOCALISER.msg("044029", (Object)handlerName, (Object)e.getMessage());
                throw new NucleusException(msg, e);
            }
            ((AbstractMetaDataHandler)handler).setValidate(this.validate);
            this.parser.parse(in, handler);
            MetaData e = ((AbstractMetaDataHandler)handler).getMetaData();
            return e;
        }
        catch (NucleusException e) {
            throw e;
        }
        catch (Exception e) {
            Exception cause = e;
            if (e instanceof SAXException) {
                SAXException se = (SAXException)e;
                cause = se.getException();
            }
            cause = e.getCause() == null ? cause : e.getCause();
            NucleusLogger.METADATA.error(LOCALISER.msg("044040", (Object)filename, (Object)cause));
            if (cause instanceof InvalidMetaDataException) {
                throw (InvalidMetaDataException)cause;
            }
            String message = LOCALISER.msg("044033", e);
            throw new NucleusException(message, cause);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ignore) {}
        }
    }

    private Source[] getRegisteredSchemas(PluginManager pm) {
        ConfigurationElement[] elems = pm.getConfigurationElementsForExtension("org.datanucleus.metadata_entityresolver", (String)null, (String)null);
        HashSet<StreamSource> sources = new HashSet<StreamSource>();
        for (int i = 0; i < elems.length; ++i) {
            if (elems[i].getAttribute("type") != null) continue;
            InputStream in = MetaDataParser.class.getResourceAsStream(elems[i].getAttribute("url"));
            if (in == null) {
                NucleusLogger.METADATA.warn("local resource \"" + elems[i].getAttribute("url") + "\" does not exist!!!");
            }
            sources.add(new StreamSource(in));
        }
        return sources.toArray(new Source[sources.size()]);
    }
}

