/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.scene.control.skin.NestedTableColumnHeader;
import com.sun.javafx.scene.control.skin.TableColumnHeader;
import com.sun.javafx.scene.control.skin.TableViewSkinBase;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.HorizontalHeader;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.input.MouseEvent;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class HorizontalHeaderColumn
extends NestedTableColumnHeader {
    int lastColumnResized = -1;

    public HorizontalHeaderColumn(TableViewSkinBase<?, ?, ?, ?, ?, ?> skin, TableColumnBase<?, ?> tc) {
        super(skin, tc);
        this.widthProperty().addListener(observable -> {
            ((GridViewSkin)skin).hBarValue.clear();
            ((GridViewSkin)skin).rectangleSelection.updateRectangle();
        });
        this.columnReorderLine.layoutXProperty().addListener((observable, oldValue, newValue) -> {
            HorizontalHeader headerRow = (HorizontalHeader)((GridViewSkin)skin).getTableHeaderRow();
            GridViewSkin mySkin = (GridViewSkin)skin;
            if (newValue.intValue() == 0 && this.lastColumnResized >= 0 && headerRow.selectedColumns.get(this.lastColumnResized)) {
                double width1 = ((TableColumn)mySkin.getColumns().get(this.lastColumnResized)).getWidth();
                int i = headerRow.selectedColumns.nextSetBit(0);
                while (i >= 0) {
                    ((TableColumn)mySkin.getColumns().get(i)).setPrefWidth(width1);
                    i = headerRow.selectedColumns.nextSetBit(i + 1);
                }
            }
        });
    }

    protected TableColumnHeader createTableColumnHeader(final TableColumnBase col) {
        final TableViewSkinBase tableViewSkin = this.getTableViewSkin();
        if (col.getColumns().isEmpty()) {
            TableColumnHeader columnHeader = new TableColumnHeader(tableViewSkin, col);
            columnHeader.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2 && mouseEvent.isPrimaryButtonDown()) {
                        ((GridViewSkin)tableViewSkin).resize(col, -1);
                    }
                }
            });
            return columnHeader;
        }
        return new HorizontalHeaderColumn(this.getTableViewSkin(), col);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.layoutFixedColumns();
    }

    public void layoutFixedColumns() {
        SpreadsheetHandle handle = ((GridViewSkin)this.getTableViewSkin()).handle;
        SpreadsheetView spreadsheetView = handle.getView();
        if (handle.getCellsViewSkin() == null || this.getChildren().isEmpty()) {
            return;
        }
        double hbarValue = handle.getCellsViewSkin().getHBar().getValue();
        int labelHeight = (int)((Node)this.getChildren().get(0)).prefHeight(-1.0);
        double fixedColumnWidth = 0.0;
        double x = this.snappedLeftInset();
        int max = this.getColumnHeaders().size();
        max = max > handle.getGridView().getVisibleLeafColumns().size() ? handle.getGridView().getVisibleLeafColumns().size() : max;
        max = max > spreadsheetView.getColumns().size() ? spreadsheetView.getColumns().size() : max;
        for (int j = 0; j < max; ++j) {
            TableColumnHeader n = (TableColumnHeader)this.getColumnHeaders().get(j);
            double prefWidth = this.snapSize(n.prefWidth(-1.0));
            n.setPrefHeight(24.0);
            if (((SpreadsheetColumn)spreadsheetView.getColumns().get(spreadsheetView.getModelColumn(j))).isFixed()) {
                double tableCellX = 0.0;
                if (hbarValue + fixedColumnWidth > x) {
                    tableCellX = Math.abs(hbarValue - x + fixedColumnWidth);
                    n.toFront();
                    fixedColumnWidth += prefWidth;
                }
                n.relocate(x + tableCellX, (double)labelHeight + this.snappedTopInset());
            }
            x += prefWidth;
        }
    }
}

