/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.impl.AuthorizationQueryImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteAuthorizationCmd
implements Command<Void> {
    protected String authorizationId;

    public DeleteAuthorizationCmd(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        AuthorizationEntity authorization = (AuthorizationEntity)new AuthorizationQueryImpl().authorizationId(this.authorizationId).singleResult();
        EnsureUtil.ensureNotNull("Authorization for Id '" + this.authorizationId + "' does not exist", "authorization", (Object)authorization);
        authorizationManager.delete(authorization);
        return null;
    }
}

