/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import javax.servlet.Filter;
import lombok.Generated;
import org.apache.catalina.filters.CsrfPreventionFilter;
import org.apache.catalina.filters.RemoteAddrFilter;
import org.apereo.cas.config.CasEmbeddedContainerTomcatConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.tomcat.CasEmbeddedApacheTomcatRemoteAddressProperties;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;

@Configuration(value="casEmbeddedContainerTomcatFiltersConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnProperty(name={"CasEmbeddedContainerConfigurationActive"}, havingValue="true")
@ImportAutoConfiguration(value={CasEmbeddedContainerTomcatConfiguration.class})
public class CasEmbeddedContainerTomcatFiltersConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasEmbeddedContainerTomcatFiltersConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnProperty(prefix="cas.server.csrf", name={"enabled"}, havingValue="true")
    @RefreshScope
    @Bean
    public FilterRegistrationBean tomcatCsrfPreventionFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new CsrfPreventionFilter());
        bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
        bean.setName("tomcatCsrfPreventionFilter");
        return bean;
    }

    @ConditionalOnProperty(prefix="cas.server.remoteAddr", name={"enabled"}, havingValue="true")
    @RefreshScope
    @Bean
    public FilterRegistrationBean tomcatRemoteAddressFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        CasEmbeddedApacheTomcatRemoteAddressProperties addr = this.casProperties.getServer().getRemoteAddr();
        RemoteAddrFilter filter = new RemoteAddrFilter();
        filter.setAllow(addr.getAllowedClientIpAddressRegex());
        filter.setDeny(addr.getDeniedClientIpAddressRegex());
        filter.setDenyStatus(HttpStatus.UNAUTHORIZED.value());
        bean.setFilter((Filter)filter);
        bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
        bean.setName("tomcatRemoteAddressFilter");
        return bean;
    }
}

