/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.redis.core;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.configuration.model.support.redis.BaseRedisProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPoolConfig;

public class RedisObjectFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisObjectFactory.class);

    public <K, V> RedisTemplate<K, V> newRedisTemplate(RedisConnectionFactory connectionFactory, Class<K> keyClass, Class<V> valueClass) {
        RedisTemplate template = new RedisTemplate();
        StringRedisSerializer string = new StringRedisSerializer();
        JdkSerializationRedisSerializer jdk = new JdkSerializationRedisSerializer();
        template.setKeySerializer((RedisSerializer)string);
        template.setValueSerializer((RedisSerializer)jdk);
        template.setHashValueSerializer((RedisSerializer)jdk);
        template.setHashKeySerializer((RedisSerializer)string);
        template.setConnectionFactory(connectionFactory);
        return template;
    }

    public RedisConnectionFactory newRedisConnectionFactory(BaseRedisProperties redis) {
        JedisPoolConfig poolConfig = redis.getPool() != null ? this.jedisPoolConfig(redis) : new JedisPoolConfig();
        JedisConnectionFactory factory = new JedisConnectionFactory(this.potentiallyGetSentinelConfig(redis), poolConfig);
        factory.setHostName(redis.getHost());
        factory.setPort(redis.getPort());
        if (redis.getPassword() != null) {
            factory.setPassword(redis.getPassword());
        }
        factory.setDatabase(redis.getDatabase());
        if (redis.getTimeout() > 0) {
            factory.setTimeout(redis.getTimeout());
        }
        factory.setUseSsl(redis.isUseSsl());
        factory.setUsePool(redis.isUsePool());
        return factory;
    }

    private JedisPoolConfig jedisPoolConfig(BaseRedisProperties redis) {
        JedisPoolConfig config = new JedisPoolConfig();
        BaseRedisProperties.Pool props = redis.getPool();
        config.setMaxTotal(props.getMaxActive());
        config.setMaxIdle(props.getMaxIdle());
        config.setMinIdle(props.getMinIdle());
        config.setMaxWaitMillis((long)props.getMaxWait());
        config.setLifo(props.isLifo());
        config.setFairness(props.isFairness());
        config.setTestWhileIdle(props.isTestWhileIdle());
        config.setTestOnBorrow(props.isTestOnBorrow());
        config.setTestOnReturn(props.isTestOnReturn());
        config.setTestOnCreate(props.isTestOnCreate());
        if (props.getMinEvictableIdleTimeMillis() > 0L) {
            config.setMinEvictableIdleTimeMillis(props.getMinEvictableIdleTimeMillis());
        }
        if (props.getNumTestsPerEvictionRun() > 0) {
            config.setNumTestsPerEvictionRun(props.getNumTestsPerEvictionRun());
        }
        if (props.getSoftMinEvictableIdleTimeMillis() > 0L) {
            config.setSoftMinEvictableIdleTimeMillis(props.getSoftMinEvictableIdleTimeMillis());
        }
        return config;
    }

    private RedisSentinelConfiguration potentiallyGetSentinelConfig(BaseRedisProperties redis) {
        if (redis.getSentinel() == null) {
            return null;
        }
        RedisSentinelConfiguration sentinelConfig = null;
        if (redis.getSentinel() != null) {
            sentinelConfig = new RedisSentinelConfiguration().master(redis.getSentinel().getMaster());
            sentinelConfig.setSentinels(this.createRedisNodesForProperties(redis));
        }
        return sentinelConfig;
    }

    private List<RedisNode> createRedisNodesForProperties(BaseRedisProperties redis) {
        ArrayList<RedisNode> redisNodes = new ArrayList<RedisNode>();
        if (redis.getSentinel().getNode() != null) {
            List nodes = redis.getSentinel().getNode();
            for (String hostAndPort : nodes) {
                String[] args = StringUtils.split((String)hostAndPort, (String)":");
                redisNodes.add(new RedisNode(args[0], Integer.parseInt(args[1])));
            }
        }
        return redisNodes;
    }
}

