/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.generic.config;

import java.util.Set;
import lombok.Generated;
import org.apereo.cas.adaptors.generic.RejectUsersAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.authentication.support.password.PasswordPolicyConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.generic.RejectAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(value="rejectUsersAuthenticationEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class RejectUsersAuthenticationEventExecutionPlanConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RejectUsersAuthenticationEventExecutionPlanConfiguration.class);
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="defaultPrincipalResolver")
    private ObjectProvider<PrincipalResolver> defaultPrincipalResolver;

    @ConditionalOnMissingBean(name={"rejectPrincipalFactory"})
    @Bean
    public PrincipalFactory rejectUsersPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @RefreshScope
    @Bean
    public AuthenticationHandler rejectUsersAuthenticationHandler() {
        RejectAuthenticationProperties rejectProperties = this.casProperties.getAuthn().getReject();
        Set users = StringUtils.commaDelimitedListToSet((String)rejectProperties.getUsers());
        RejectUsersAuthenticationHandler h = new RejectUsersAuthenticationHandler(rejectProperties.getName(), (ServicesManager)this.servicesManager.getIfAvailable(), this.rejectUsersPrincipalFactory(), users);
        h.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)rejectProperties.getPasswordEncoder()));
        h.setPasswordPolicyConfiguration(this.rejectPasswordPolicyConfiguration());
        h.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)rejectProperties.getPrincipalTransformation()));
        return h;
    }

    @ConditionalOnMissingBean(name={"rejectUsersAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer rejectUsersAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            String users = this.casProperties.getAuthn().getReject().getUsers();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)users)) {
                plan.registerAuthenticationHandlerWithPrincipalResolver(this.rejectUsersAuthenticationHandler(), (PrincipalResolver)this.defaultPrincipalResolver.getIfAvailable());
                LOGGER.debug("Added rejecting authentication handler with the following users [{}]", (Object)users);
            }
        };
    }

    @ConditionalOnMissingBean(name={"rejectPasswordPolicyConfiguration"})
    @Bean
    public PasswordPolicyConfiguration rejectPasswordPolicyConfiguration() {
        return new PasswordPolicyConfiguration();
    }
}

