/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.generic.config;

import lombok.Generated;
import org.apereo.cas.adaptors.generic.JsonResourceAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.authentication.support.password.PasswordPolicyConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.generic.JsonResourceAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration(value="jsonResourceAuthenticationEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class JsonResourceAuthenticationEventExecutionPlanConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonResourceAuthenticationEventExecutionPlanConfiguration.class);
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="defaultPrincipalResolver")
    private ObjectProvider<PrincipalResolver> defaultPrincipalResolver;

    @ConditionalOnMissingBean(name={"jsonPrincipalFactory"})
    @Bean
    public PrincipalFactory jsonPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @RefreshScope
    @Bean
    public AuthenticationHandler jsonResourceAuthenticationHandler() {
        JsonResourceAuthenticationProperties jsonProps = this.casProperties.getAuthn().getJson();
        JsonResourceAuthenticationHandler h = new JsonResourceAuthenticationHandler(jsonProps.getName(), (ServicesManager)this.servicesManager.getIfAvailable(), this.jsonPrincipalFactory(), null, jsonProps.getLocation());
        h.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)jsonProps.getPasswordEncoder()));
        if (jsonProps.getPasswordPolicy().isEnabled()) {
            h.setPasswordPolicyConfiguration(new PasswordPolicyConfiguration(jsonProps.getPasswordPolicy()));
        }
        h.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)jsonProps.getPrincipalTransformation()));
        return h;
    }

    @ConditionalOnMissingBean(name={"jsonResourceAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer jsonResourceAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            Resource file = this.casProperties.getAuthn().getJson().getLocation();
            if (file != null) {
                LOGGER.debug("Added JSON resource authentication handler for the target file [{}]", (Object)file.getFilename());
                plan.registerAuthenticationHandlerWithPrincipalResolver(this.jsonResourceAuthenticationHandler(), (PrincipalResolver)this.defaultPrincipalResolver.getIfAvailable());
            }
        };
    }
}

