/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.generic;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Set;
import javax.security.auth.login.FailedLoginException;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;

public class RejectUsersAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private final Set<String> users;

    public RejectUsersAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Set<String> rejectedUsers) {
        super(name, servicesManager, principalFactory, null);
        this.users = rejectedUsers;
    }

    protected AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential, String originalPassword) throws GeneralSecurityException {
        String username = credential.getUsername();
        if (this.users.contains(username)) {
            throw new FailedLoginException();
        }
        return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username), new ArrayList(0));
    }
}

