/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl.mfa;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.flow.authentication.BaseMultifactorAuthenticationProviderEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class PrincipalAttributeMultifactorAuthenticationPolicyEventResolver
extends BaseMultifactorAuthenticationProviderEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PrincipalAttributeMultifactorAuthenticationPolicyEventResolver.class);
    protected final String globalPrincipalAttributeValueRegex;
    protected final Set<String> attributeNames;

    public PrincipalAttributeMultifactorAuthenticationPolicyEventResolver(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, CookieGenerator warnCookieGenerator, AuthenticationServiceSelectionPlan authSelectionStrategies, MultifactorAuthenticationProviderSelector selector, CasConfigurationProperties casProperties) {
        super(authenticationSystemSupport, centralAuthenticationService, servicesManager, ticketRegistrySupport, warnCookieGenerator, authSelectionStrategies, selector);
        this.globalPrincipalAttributeValueRegex = casProperties.getAuthn().getMfa().getGlobalPrincipalAttributeValueRegex();
        this.attributeNames = StringUtils.commaDelimitedListToSet((String)casProperties.getAuthn().getMfa().getGlobalPrincipalAttributeNameTriggers());
    }

    @Override
    public Set<Event> resolveInternal(RequestContext context) {
        RegisteredService service = this.resolveRegisteredServiceInRequestContext(context);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)context);
        if (authentication == null) {
            LOGGER.debug("No authentication is available to determine event for principal");
            return null;
        }
        Principal principal = authentication.getPrincipal();
        return this.resolveMultifactorAuthenticationProvider(context, service, principal);
    }

    protected Set<Event> resolveMultifactorAuthenticationProvider(RequestContext context, RegisteredService service, Principal principal) {
        Map providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
        Collection<MultifactorAuthenticationProvider> providers = this.flattenProviders(providerMap.values());
        if (providers.size() == 1 && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.globalPrincipalAttributeValueRegex)) {
            return this.resolveSingleMultifactorProvider(context, service, principal, providers);
        }
        return this.resolveMultifactorProviderViaPredicate(context, service, principal, providers);
    }

    protected Set<Event> resolveMultifactorProviderViaPredicate(RequestContext context, RegisteredService service, Principal principal, Collection<MultifactorAuthenticationProvider> providers) {
        return this.resolveEventViaPrincipalAttribute(principal, this.attributeNames, service, context, providers, input -> providers.stream().anyMatch(provider -> input != null && provider.matches(input)));
    }

    protected Set<Event> resolveSingleMultifactorProvider(RequestContext context, RegisteredService service, Principal principal, Collection<MultifactorAuthenticationProvider> providers) {
        MultifactorAuthenticationProvider provider = providers.iterator().next();
        LOGGER.debug("Found a single multifactor provider [{}] in the application context", (Object)provider);
        return this.resolveEventViaPrincipalAttribute(principal, this.attributeNames, service, context, providers, input -> input != null && input.matches(this.globalPrincipalAttributeValueRegex));
    }

    @Override
    @Audit(action="AUTHENTICATION_EVENT", actionResolverName="AUTHENTICATION_EVENT_ACTION_RESOLVER", resourceResolverName="AUTHENTICATION_EVENT_RESOURCE_RESOLVER")
    public Event resolveSingle(RequestContext context) {
        return super.resolveSingle(context);
    }
}

