/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl.mfa;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.flow.authentication.BaseMultifactorAuthenticationProviderEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class AuthenticationAttributeMultifactorAuthenticationPolicyEventResolver
extends BaseMultifactorAuthenticationProviderEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationAttributeMultifactorAuthenticationPolicyEventResolver.class);
    private final String globalAuthenticationAttributeValueRegex;
    private final Set<String> attributeNames;

    public AuthenticationAttributeMultifactorAuthenticationPolicyEventResolver(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, CookieGenerator warnCookieGenerator, AuthenticationServiceSelectionPlan selectionStrategies, MultifactorAuthenticationProviderSelector selector, CasConfigurationProperties casProperties) {
        super(authenticationSystemSupport, centralAuthenticationService, servicesManager, ticketRegistrySupport, warnCookieGenerator, selectionStrategies, selector);
        this.globalAuthenticationAttributeValueRegex = casProperties.getAuthn().getMfa().getGlobalAuthenticationAttributeValueRegex();
        this.attributeNames = StringUtils.commaDelimitedListToSet((String)casProperties.getAuthn().getMfa().getGlobalAuthenticationAttributeNameTriggers());
    }

    @Override
    public Set<Event> resolveInternal(RequestContext context) {
        RegisteredService service = this.resolveRegisteredServiceInRequestContext(context);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)context);
        if (authentication == null) {
            LOGGER.debug("No authentication is available to determine event for principal");
            return null;
        }
        if (this.attributeNames.isEmpty()) {
            LOGGER.debug("Authentication attribute name to determine event is not configured");
            return null;
        }
        Map providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
        if (providerMap == null || providerMap.isEmpty()) {
            LOGGER.error("No multifactor authentication providers are available in the application context");
            return null;
        }
        Collection<MultifactorAuthenticationProvider> providers = this.flattenProviders(providerMap.values());
        if (providers.size() == 1 && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.globalAuthenticationAttributeValueRegex)) {
            MultifactorAuthenticationProvider provider = providers.iterator().next();
            LOGGER.debug("Found a single multifactor provider [{}] in the application context", (Object)provider);
            return this.resolveEventViaAuthenticationAttribute(authentication, this.attributeNames, service, context, providers, input -> input != null && input.matches(this.globalAuthenticationAttributeValueRegex));
        }
        return this.resolveEventViaAuthenticationAttribute(authentication, this.attributeNames, service, context, providers, input -> providers.stream().filter(provider -> input != null && provider.matches(input)).count() > 0L);
    }

    @Override
    @Audit(action="AUTHENTICATION_EVENT", actionResolverName="AUTHENTICATION_EVENT_ACTION_RESOLVER", resourceResolverName="AUTHENTICATION_EVENT_RESOURCE_RESOLVER")
    public Event resolveSingle(RequestContext context) {
        return super.resolveSingle(context);
    }
}

