/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractCasWebflowEventResolver
implements CasWebflowEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCasWebflowEventResolver.class);
    private static final String RESOLVED_AUTHENTICATION_EVENTS = "resolvedAuthenticationEvents";
    private static final String DEFAULT_MESSAGE_BUNDLE_PREFIX = "authenticationFailure.";
    @Autowired
    protected ApplicationEventPublisher eventPublisher;
    @Autowired
    protected ConfigurableApplicationContext applicationContext;
    protected final AuthenticationSystemSupport authenticationSystemSupport;
    protected final CentralAuthenticationService centralAuthenticationService;
    protected final ServicesManager servicesManager;
    protected final TicketRegistrySupport ticketRegistrySupport;
    protected final CookieGenerator warnCookieGenerator;
    protected final AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;
    protected final MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector;

    protected Event newEvent(String id, Exception error) {
        return this.newEvent(id, (AttributeMap)new LocalAttributeMap("error", (Object)error));
    }

    protected Event newEvent(String id) {
        return this.newEvent(id, (AttributeMap)new LocalAttributeMap());
    }

    protected Event newEvent(String id, AttributeMap attributes) {
        return new Event((Object)this, id, attributes);
    }

    protected Credential getCredentialFromContext(RequestContext context) {
        return WebUtils.getCredential((RequestContext)context);
    }

    protected Event grantTicketGrantingTicketToAuthenticationResult(RequestContext context, AuthenticationResultBuilder authenticationResultBuilder, Service service) {
        WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)authenticationResultBuilder, (RequestContext)context);
        WebUtils.putService((RequestContext)context, (Service)service);
        return this.newEvent("success");
    }

    protected Collection<MultifactorAuthenticationProvider> getAuthenticationProviderForService(RegisteredService service) {
        RegisteredServiceMultifactorPolicy policy = service.getMultifactorPolicy();
        if (policy != null) {
            return policy.getMultifactorAuthenticationProviders().stream().map(this::getMultifactorAuthenticationProviderFromApplicationContext).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        }
        return null;
    }

    protected Event validateEventIdForMatchingTransitionInContext(String eventId, RequestContext context, Map<String, Object> attributes) {
        LocalAttributeMap attributesMap = new LocalAttributeMap(attributes);
        Event event = new Event((Object)this, eventId, (AttributeMap)attributesMap);
        LOGGER.debug("Resulting event id is [{}] by provider [{}]. Locating transitions in the context for that event id...", (Object)event.getId(), (Object)this.getName());
        TransitionDefinition def = context.getMatchingTransition(event.getId());
        if (def == null) {
            LOGGER.warn("Transition definition cannot be found for event [{}]", (Object)event.getId());
            throw new AuthenticationException();
        }
        LOGGER.debug("Found matching transition [{}] with target [{}] for event [{}] with attributes [{}].", new Object[]{def.getId(), def.getTargetStateId(), event.getId(), event.getAttributes()});
        return event;
    }

    protected static Map<String, Object> buildEventAttributeMap(Principal principal, RegisteredService service, MultifactorAuthenticationProvider provider) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Principal.class.getName(), principal);
        if (service != null) {
            map.put(RegisteredService.class.getName(), service);
        }
        map.put(MultifactorAuthenticationProvider.class.getName(), provider);
        return map;
    }

    private Set<Event> resolveEventViaMultivaluedAttribute(Principal principal, Object attributeValue, RegisteredService service, RequestContext context, MultifactorAuthenticationProvider provider, Predicate<String> predicate) {
        HashSet<Event> events = new HashSet<Event>();
        if (attributeValue instanceof Collection) {
            LOGGER.debug("Attribute value [{}] is a multi-valued attribute", attributeValue);
            Collection values = (Collection)attributeValue;
            values.forEach(value -> {
                try {
                    if (predicate.test((String)value)) {
                        LOGGER.debug("Attribute value predicate [{}] has successfully matched the [{}]. Attempting to verify multifactor authentication for [{}]", new Object[]{predicate, value, service});
                        String id = provider.getId();
                        Event event = this.validateEventIdForMatchingTransitionInContext(id, context, AbstractCasWebflowEventResolver.buildEventAttributeMap(principal, service, provider));
                        events.add(event);
                    } else {
                        LOGGER.debug("Attribute value predicate [{}] could not match the [{}]", (Object)predicate, value);
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Ignoring [{}] since no matching transition could be found", value);
                }
            });
            return events;
        }
        LOGGER.debug("Attribute value [{}] of type [{}] is not a multi-valued attribute", attributeValue, attributeValue.getClass());
        return null;
    }

    private Set<Event> resolveEventViaSingleAttribute(Principal principal, Object attributeValue, RegisteredService service, RequestContext context, MultifactorAuthenticationProvider provider, Predicate<String> predicate) {
        if (attributeValue instanceof String) {
            LOGGER.debug("Attribute value [{}] is a single-valued attribute", attributeValue);
            if (predicate.test((String)attributeValue)) {
                LOGGER.debug("Attribute value predicate [{}] has matched the [{}]", predicate, attributeValue);
                return this.evaluateEventForProviderInContext(principal, service, context, provider);
            }
            LOGGER.debug("Attribute value predicate [{}] could not match the [{}]", predicate, attributeValue);
        }
        LOGGER.debug("Attribute value [{}] is not a single-valued attribute", attributeValue);
        return null;
    }

    protected Set<Event> evaluateEventForProviderInContext(Principal principal, RegisteredService service, RequestContext context, MultifactorAuthenticationProvider provider) {
        if (provider == null) {
            LOGGER.debug("No multifactor authentication provider is specified");
            return null;
        }
        LOGGER.debug("Provider [{}] is successfully verified", (Object)provider);
        String id = provider.getId();
        Event event = this.validateEventIdForMatchingTransitionInContext(id, context, AbstractCasWebflowEventResolver.buildEventAttributeMap(principal, service, provider));
        return CollectionUtils.wrapSet((Object)event);
    }

    private Set<Event> resolveEventViaAttribute(Principal principal, Map<String, Object> attributesToExamine, Collection<String> attributeNames, RegisteredService service, RequestContext context, Collection<MultifactorAuthenticationProvider> providers, Predicate<String> predicate) {
        if (providers == null || providers.isEmpty()) {
            LOGGER.debug("No authentication provider is associated with this service");
            return null;
        }
        LOGGER.debug("Locating attribute value for attribute(s): [{}]", attributeNames);
        for (String attributeName : attributeNames) {
            Object attributeValue = attributesToExamine.get(attributeName);
            if (attributeValue == null) {
                LOGGER.debug("Attribute value for [{}] to determine event is not configured for [{}]", (Object)attributeName, (Object)principal.getId());
                continue;
            }
            LOGGER.debug("Selecting a multifactor authentication provider out of [{}] for [{}] and service [{}]", new Object[]{providers, principal.getId(), service});
            MultifactorAuthenticationProvider provider = this.multifactorAuthenticationProviderSelector.resolve(providers, service, principal);
            LOGGER.debug("Located attribute value [{}] for [{}]", attributeValue, attributeNames);
            Set<Event> results = this.resolveEventViaSingleAttribute(principal, attributeValue, service, context, provider, predicate);
            if (results == null || results.isEmpty()) {
                results = this.resolveEventViaMultivaluedAttribute(principal, attributeValue, service, context, provider, predicate);
            }
            if (results == null || results.isEmpty()) continue;
            LOGGER.debug("Resolved set of events based on the attribute [{}] are [{}]", (Object)attributeName, results);
            return results;
        }
        LOGGER.debug("No set of events based on the attribute(s) [{}] could be matched", attributeNames);
        return null;
    }

    protected Set<Event> resolveEventViaAuthenticationAttribute(Authentication authentication, Collection<String> attributeNames, RegisteredService service, RequestContext context, Collection<MultifactorAuthenticationProvider> providers, Predicate<String> predicate) {
        return this.resolveEventViaAttribute(authentication.getPrincipal(), authentication.getAttributes(), attributeNames, service, context, providers, predicate);
    }

    protected Set<Event> resolveEventViaPrincipalAttribute(Principal principal, Collection<String> attributeNames, RegisteredService service, RequestContext context, Collection<MultifactorAuthenticationProvider> providers, Predicate<String> predicate) {
        if (attributeNames.isEmpty()) {
            LOGGER.debug("No attribute names are provided to trigger a multifactor authentication provider via [{}]", (Object)this.getName());
            return null;
        }
        if (providers == null || providers.isEmpty()) {
            LOGGER.error("No multifactor authentication providers are available in the application context");
            return null;
        }
        Map<String, Object> attributes = this.getPrincipalAttributesForMultifactorAuthentication(principal);
        return this.resolveEventViaAttribute(principal, attributes, attributeNames, service, context, providers, predicate);
    }

    @Override
    public Set<Event> resolve(RequestContext context) {
        LOGGER.debug("Attempting to resolve authentication event using resolver [{}]", (Object)this.getName());
        WebUtils.putWarnCookieIfRequestParameterPresent((CookieGenerator)this.warnCookieGenerator, (RequestContext)context);
        WebUtils.putPublicWorkstationToFlowIfRequestParameterPresent((RequestContext)context);
        return this.resolveInternal(context);
    }

    @Override
    public Event resolveSingle(RequestContext context) {
        Set<Event> events = this.resolve(context);
        if (events == null || events.isEmpty()) {
            return null;
        }
        Event event = events.iterator().next();
        LOGGER.debug("Resolved single event [{}] via [{}] for this context", (Object)event.getId(), (Object)event.getSource().getClass().getName());
        return event;
    }

    protected Optional<MultifactorAuthenticationProvider> getMultifactorAuthenticationProviderFromApplicationContext(String providerId) {
        try {
            LOGGER.debug("Locating bean definition for [{}]", (Object)providerId);
            return MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext).values().stream().filter(p -> p.matches(providerId)).findFirst();
        }
        catch (Exception e) {
            LOGGER.debug("Could not locate [{}] bean id in the application context as an authentication provider.", (Object)providerId);
            return Optional.empty();
        }
    }

    protected void putResolvedEventsAsAttribute(RequestContext context, Set<Event> resolvedEvents) {
        context.getAttributes().put(RESOLVED_AUTHENTICATION_EVENTS, resolvedEvents);
    }

    protected Service resolveServiceFromAuthenticationRequest(Service service) {
        return this.authenticationRequestServiceSelectionStrategies.resolveService(service);
    }

    protected Service resolveServiceFromAuthenticationRequest(RequestContext context) {
        WebApplicationService ctxService = WebUtils.getService((RequestContext)context);
        return this.resolveServiceFromAuthenticationRequest((Service)ctxService);
    }

    protected Set<Event> getResolvedEventsAsAttribute(RequestContext context) {
        return (Set)context.getAttributes().get(RESOLVED_AUTHENTICATION_EVENTS, Set.class);
    }

    protected Set<Event> handleAuthenticationTransactionAndGrantTicketGrantingTicket(RequestContext context) {
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        try {
            Credential credential = this.getCredentialFromContext(context);
            AuthenticationResultBuilder builder = WebUtils.getAuthenticationResultBuilder((RequestContext)context);
            LOGGER.debug("Handling authentication transaction for credential [{}]", (Object)credential);
            WebApplicationService service = WebUtils.getService((RequestContext)context);
            builder = this.authenticationSystemSupport.handleAuthenticationTransaction((Service)service, builder, new Credential[]{credential});
            LOGGER.debug("Issuing ticket-granting tickets for service [{}]", (Object)service);
            return CollectionUtils.wrapSet((Object)this.grantTicketGrantingTicketToAuthenticationResult(context, builder, (Service)service));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            MessageContext messageContext = context.getMessageContext();
            messageContext.addMessage(new MessageBuilder().error().code(DEFAULT_MESSAGE_BUNDLE_PREFIX.concat(e.getClass().getSimpleName())).build());
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            return CollectionUtils.wrapSet((Object)this.getAuthenticationFailureErrorEvent(context));
        }
    }

    protected Event getAuthenticationFailureErrorEvent(RequestContext context) {
        return new EventFactorySupport().error((Object)this);
    }

    protected Map<String, Object> getPrincipalAttributesForMultifactorAuthentication(Principal principal) {
        return principal.getAttributes();
    }

    @Generated
    public AbstractCasWebflowEventResolver(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, CookieGenerator warnCookieGenerator, AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector) {
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.centralAuthenticationService = centralAuthenticationService;
        this.servicesManager = servicesManager;
        this.ticketRegistrySupport = ticketRegistrySupport;
        this.warnCookieGenerator = warnCookieGenerator;
        this.authenticationRequestServiceSelectionStrategies = authenticationRequestServiceSelectionStrategies;
        this.multifactorAuthenticationProviderSelector = multifactorAuthenticationProviderSelector;
    }
}

