/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.authentication;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.MultifactorAuthenticationProviderResolver;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.VariegatedMultifactorAuthenticationProvider;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.resolver.impl.AbstractCasWebflowEventResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.execution.RequestContext;

public abstract class BaseMultifactorAuthenticationProviderEventResolver
extends AbstractCasWebflowEventResolver
implements MultifactorAuthenticationProviderResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseMultifactorAuthenticationProviderEventResolver.class);

    public BaseMultifactorAuthenticationProviderEventResolver(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, CookieGenerator warnCookieGenerator, AuthenticationServiceSelectionPlan authenticationSelectionStrategies, MultifactorAuthenticationProviderSelector selector) {
        super(authenticationSystemSupport, centralAuthenticationService, servicesManager, ticketRegistrySupport, warnCookieGenerator, authenticationSelectionStrategies, selector);
    }

    public Optional<MultifactorAuthenticationProvider> resolveProvider(Map<String, MultifactorAuthenticationProvider> providers, Collection<String> requestMfaMethod) {
        MultifactorAuthenticationProvider provider;
        Optional<MultifactorAuthenticationProvider> providerFound = providers.values().stream().filter(p -> requestMfaMethod.stream().filter(Objects::nonNull).anyMatch(arg_0 -> ((MultifactorAuthenticationProvider)p).matches(arg_0))).findFirst();
        if (providerFound.isPresent() && (provider = providerFound.get()) instanceof VariegatedMultifactorAuthenticationProvider) {
            VariegatedMultifactorAuthenticationProvider multi = (VariegatedMultifactorAuthenticationProvider)VariegatedMultifactorAuthenticationProvider.class.cast(provider);
            return multi.getProviders().stream().filter(p -> requestMfaMethod.stream().anyMatch(arg_0 -> ((MultifactorAuthenticationProvider)p).matches(arg_0))).findFirst();
        }
        return providerFound;
    }

    public Optional<MultifactorAuthenticationProvider> resolveProvider(Map<String, MultifactorAuthenticationProvider> providers, String requestMfaMethod) {
        return this.resolveProvider(providers, CollectionUtils.wrap((Object)requestMfaMethod));
    }

    public Collection<MultifactorAuthenticationProvider> flattenProviders(Collection<? extends MultifactorAuthenticationProvider> providers) {
        HashSet<MultifactorAuthenticationProvider> flattenedProviders = new HashSet<MultifactorAuthenticationProvider>();
        providers.forEach(p -> {
            if (p instanceof VariegatedMultifactorAuthenticationProvider) {
                flattenedProviders.addAll(((VariegatedMultifactorAuthenticationProvider)VariegatedMultifactorAuthenticationProvider.class.cast(p)).getProviders());
            } else {
                flattenedProviders.add((MultifactorAuthenticationProvider)p);
            }
        });
        return flattenedProviders;
    }

    protected RegisteredService resolveRegisteredServiceInRequestContext(RequestContext requestContext) {
        Service resolvedService = this.resolveServiceFromAuthenticationRequest(requestContext);
        if (resolvedService != null) {
            RegisteredService service = this.servicesManager.findServiceBy(resolvedService);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)resolvedService, (RegisteredService)service);
            return service;
        }
        LOGGER.debug("Authentication request is not accompanied by a service given none is specified");
        return null;
    }
}

