/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.services.AbstractServiceRegistry;
import org.apereo.cas.services.ImmutableServiceRegistry;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainingServiceRegistry
extends AbstractServiceRegistry {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ChainingServiceRegistry.class);
    private final Collection<ServiceRegistry> serviceRegistries;

    public RegisteredService save(RegisteredService registeredService) {
        this.serviceRegistries.forEach(registry -> registry.save(registeredService));
        return registeredService;
    }

    public boolean delete(RegisteredService registeredService) {
        return this.serviceRegistries.stream().map(registry -> registry.delete(registeredService)).filter(Boolean::booleanValue).findAny().orElse(Boolean.FALSE);
    }

    public List<RegisteredService> load() {
        return this.serviceRegistries.stream().map(ServiceRegistry::load).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public RegisteredService findServiceById(long id) {
        return this.serviceRegistries.stream().map(registry -> registry.findServiceById(id)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public RegisteredService findServiceById(String id) {
        return this.serviceRegistries.stream().map(registry -> registry.findServiceById(id)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public RegisteredService findServiceByExactServiceId(String id) {
        return this.serviceRegistries.stream().map(registry -> registry.findServiceByExactServiceId(id)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public RegisteredService findServiceByExactServiceName(String name) {
        return this.serviceRegistries.stream().map(registry -> registry.findServiceByExactServiceName(name)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public long size() {
        Predicate filter = Predicates.not((Predicate)Predicates.instanceOf(ImmutableServiceRegistry.class));
        return this.serviceRegistries.stream().filter(arg_0 -> ((Predicate)filter).test(arg_0)).map(ServiceRegistry::size).mapToLong(Long::longValue).sum();
    }

    @Override
    public String getName() {
        Predicate filter = Predicates.not((Predicate)Predicates.instanceOf(ImmutableServiceRegistry.class));
        return this.serviceRegistries.stream().filter(arg_0 -> ((Predicate)filter).test(arg_0)).map(ServiceRegistry::getName).collect(Collectors.joining(","));
    }

    @Generated
    public ChainingServiceRegistry(Collection<ServiceRegistry> serviceRegistries) {
        this.serviceRegistries = serviceRegistries;
    }

    @Generated
    public Collection<ServiceRegistry> getServiceRegistries() {
        return this.serviceRegistries;
    }
}

