/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.DefaultResponse;
import org.apereo.cas.authentication.principal.Response;
import org.apereo.cas.authentication.principal.ResponseBuilder;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.HttpRequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebApplicationServiceResponseBuilder
implements ResponseBuilder<WebApplicationService> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWebApplicationServiceResponseBuilder.class);
    private static final long serialVersionUID = -4584738964007702423L;
    protected final ServicesManager servicesManager;
    private int order;

    protected Response buildRedirect(WebApplicationService service, Map<String, String> parameters) {
        return DefaultResponse.getRedirectResponse(service.getOriginalUrl(), parameters);
    }

    protected Response buildHeader(WebApplicationService service, Map<String, String> parameters) {
        return DefaultResponse.getHeaderResponse(service.getOriginalUrl(), parameters);
    }

    protected Response buildPost(WebApplicationService service, Map<String, String> parameters) {
        return DefaultResponse.getPostResponse(service.getOriginalUrl(), parameters);
    }

    protected Response.ResponseType getWebApplicationServiceResponseType(WebApplicationService finalService) {
        RegisteredService registeredService;
        String method;
        HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
        String string = method = request != null ? request.getParameter("method") : null;
        if (StringUtils.isBlank((CharSequence)method) && (registeredService = this.servicesManager.findServiceBy((Service)finalService)) != null) {
            method = registeredService.getResponseType();
        }
        if (StringUtils.isBlank((CharSequence)method)) {
            return Response.ResponseType.REDIRECT;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)Response.ResponseType.HEADER.name())) {
            return Response.ResponseType.HEADER;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)Response.ResponseType.POST.name())) {
            return Response.ResponseType.POST;
        }
        return Response.ResponseType.REDIRECT;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public AbstractWebApplicationServiceResponseBuilder(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }
}

