/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorTriggerSelectionStrategy;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProperties;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DefaultMultifactorTriggerSelectionStrategy
implements MultifactorTriggerSelectionStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMultifactorTriggerSelectionStrategy.class);
    private final MultifactorAuthenticationProperties mfaProperties;

    public Optional<String> resolve(Collection<MultifactorAuthenticationProvider> providers, HttpServletRequest request, RegisteredService service, Authentication authentication) {
        if (providers == null || providers.isEmpty()) {
            return Optional.empty();
        }
        Set<String> validProviderIds = providers.stream().map(MultifactorAuthenticationProvider::getId).collect(Collectors.toSet());
        Principal principal = authentication != null ? authentication.getPrincipal() : null;
        Optional<String> provider = this.resolveRequestParameterTrigger(request, validProviderIds);
        if (!provider.isPresent()) {
            provider = this.resolveRegisteredServiceTrigger(service, principal, validProviderIds);
        }
        if (!provider.isPresent()) {
            provider = this.resolvePrincipalAttributeTrigger(principal, validProviderIds);
        }
        if (!provider.isPresent()) {
            provider = this.resolveAuthenticationAttributeTrigger(authentication, validProviderIds);
        }
        return provider;
    }

    private Optional<String> resolveRequestParameterTrigger(HttpServletRequest request, Set<String> providerIds) {
        return Optional.ofNullable(request).map(r -> r.getParameter(this.mfaProperties.getRequestParameter())).filter(providerIds::contains);
    }

    private Optional<String> resolveRegisteredServiceTrigger(RegisteredService service, Principal principal, Set<String> providerIds) {
        if (service == null) {
            return Optional.empty();
        }
        RegisteredServiceMultifactorPolicy policy = service.getMultifactorPolicy();
        String attrName = policy.getPrincipalAttributeNameTrigger();
        String attrValue = policy.getPrincipalAttributeValueToMatch();
        if (!StringUtils.hasText((String)attrName) || !StringUtils.hasText((String)attrValue)) {
            return this.resolveRegisteredServicePolicyTrigger(policy, providerIds);
        }
        if (principal == null) {
            return this.resolveRegisteredServicePolicyTrigger(policy, providerIds);
        }
        if (this.hasMatchingAttribute(principal.getAttributes(), attrName, attrValue)) {
            return this.resolveRegisteredServicePolicyTrigger(policy, providerIds);
        }
        return Optional.empty();
    }

    private Optional<String> resolveRegisteredServicePolicyTrigger(RegisteredServiceMultifactorPolicy policy, Set<String> providerIds) {
        return policy.getMultifactorAuthenticationProviders().stream().filter(providerIds::contains).findFirst();
    }

    private Optional<String> resolveAuthenticationAttributeTrigger(Authentication authentication, Set<String> providerIds) {
        if (authentication == null) {
            return Optional.empty();
        }
        return this.resolveAttributeTrigger(authentication.getAttributes(), this.mfaProperties.getGlobalAuthenticationAttributeNameTriggers(), this.mfaProperties.getGlobalAuthenticationAttributeValueRegex(), providerIds);
    }

    private Optional<String> resolvePrincipalAttributeTrigger(Principal principal, Set<String> providerIds) {
        if (principal == null) {
            return Optional.empty();
        }
        return this.resolveAttributeTrigger(principal.getAttributes(), this.mfaProperties.getGlobalPrincipalAttributeNameTriggers(), this.mfaProperties.getGlobalPrincipalAttributeValueRegex(), providerIds);
    }

    private Optional<String> resolveAttributeTrigger(Map<String, Object> attributes, String names, String value, Set<String> providerIds) {
        if (!StringUtils.hasText((String)names)) {
            return Optional.empty();
        }
        if (providerIds.size() == 1 && this.hasMatchingAttribute(attributes, names, value)) {
            return providerIds.stream().findAny();
        }
        return this.resolveAttributeTrigger(attributes, names, providerIds);
    }

    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    private Optional<String> resolveAttributeTrigger(Map<String, Object> attributes, String names, Set<String> providerIds) {
        return StringUtils.commaDelimitedListToSet((String)names).stream().map(attributes::get).filter(Objects::nonNull).map(CollectionUtils::toCollection).flatMap(Collection::stream).filter(String.class::isInstance).map(String.class::cast).filter(providerIds::contains).findFirst();
    }

    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    private boolean hasMatchingAttribute(Map<String, Object> attributes, String names, String value) {
        if (!StringUtils.hasText((String)names) || !StringUtils.hasText((String)value)) {
            return false;
        }
        Predicate<String> valuePredicate = Pattern.compile(value).asPredicate();
        return StringUtils.commaDelimitedListToSet((String)names).stream().map(attributes::get).filter(Objects::nonNull).map(CollectionUtils::toCollection).flatMap(Collection::stream).map(Object::toString).anyMatch(valuePredicate);
    }

    @Generated
    public DefaultMultifactorTriggerSelectionStrategy(MultifactorAuthenticationProperties mfaProperties) {
        this.mfaProperties = mfaProperties;
    }
}

