/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal.resolvers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.handler.PrincipalNameTransformer;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.IPersonAttributes;
import org.apereo.services.persondir.support.StubPersonAttributeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PersonDirectoryPrincipalResolver
implements PrincipalResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PersonDirectoryPrincipalResolver.class);
    protected final IPersonAttributeDao attributeRepository;
    protected final PrincipalFactory principalFactory;
    protected final boolean returnNullIfNoAttributes;
    protected final PrincipalNameTransformer principalNameTransformer;
    protected final String principalAttributeNames;
    protected final boolean useCurrentPrincipalId;

    public PersonDirectoryPrincipalResolver() {
        this((IPersonAttributeDao)new StubPersonAttributeDao(new HashMap()), PrincipalFactoryUtils.newPrincipalFactory(), false, String::trim, null, false);
    }

    public PersonDirectoryPrincipalResolver(IPersonAttributeDao attributeRepository, String principalAttributeNames) {
        this(attributeRepository, PrincipalFactoryUtils.newPrincipalFactory(), false, formUserId -> formUserId, principalAttributeNames, false);
    }

    public PersonDirectoryPrincipalResolver(IPersonAttributeDao attributeRepository) {
        this(attributeRepository, PrincipalFactoryUtils.newPrincipalFactory(), false, formUserId -> formUserId, null, false);
    }

    public PersonDirectoryPrincipalResolver(boolean returnNullIfNoAttributes, String principalAttributeNames) {
        this((IPersonAttributeDao)new StubPersonAttributeDao(new HashMap()), PrincipalFactoryUtils.newPrincipalFactory(), returnNullIfNoAttributes, String::trim, principalAttributeNames, false);
    }

    public PersonDirectoryPrincipalResolver(IPersonAttributeDao attributeRepository, PrincipalFactory principalFactory, boolean returnNullIfNoAttributes, String principalAttributeNames, boolean useCurrentPrincipalId) {
        this(attributeRepository, principalFactory, returnNullIfNoAttributes, formUserId -> formUserId, principalAttributeNames, useCurrentPrincipalId);
    }

    public boolean supports(Credential credential) {
        return credential != null && credential.getId() != null;
    }

    public Principal resolve(Credential credential, Optional<Principal> currentPrincipal, Optional<AuthenticationHandler> handler) {
        LOGGER.debug("Attempting to resolve a principal...");
        String principalId = this.extractPrincipalId(credential, currentPrincipal);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)principalId)) {
            LOGGER.debug("Principal id [{}] could not be found", (Object)principalId);
            return null;
        }
        if (this.principalNameTransformer != null) {
            principalId = this.principalNameTransformer.transform(principalId);
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)principalId)) {
            LOGGER.debug("Principal id [{}] could not be found", (Object)principalId);
            return null;
        }
        LOGGER.debug("Creating principal for [{}]", (Object)principalId);
        Map<String, List<Object>> attributes = this.retrievePersonAttributes(principalId, credential);
        if (attributes == null || attributes.isEmpty()) {
            LOGGER.debug("Principal id [{}] did not specify any attributes", (Object)principalId);
            if (!this.returnNullIfNoAttributes) {
                LOGGER.debug("Returning the principal with id [{}] without any attributes", (Object)principalId);
                return this.principalFactory.createPrincipal(principalId);
            }
            LOGGER.debug("[{}] is configured to return null if no attributes are found for [{}]", (Object)this.getClass().getName(), (Object)principalId);
            return null;
        }
        LOGGER.debug("Retrieved [{}] attribute(s) from the repository", (Object)attributes.size());
        Pair<String, Map<String, Object>> pair = this.convertPersonAttributesToPrincipal(principalId, attributes);
        Principal principal = this.principalFactory.createPrincipal((String)pair.getKey(), (Map)pair.getValue());
        LOGGER.info("Final resolved principal by [{}] is [{}]", (Object)this.getName(), (Object)principal);
        return principal;
    }

    protected Pair<String, Map<String, Object>> convertPersonAttributesToPrincipal(String extractedPrincipalId, Map<String, List<Object>> attributes) {
        LinkedHashMap convertedAttributes = new LinkedHashMap();
        attributes.forEach((key, attrValue) -> {
            ArrayList values = (ArrayList)CollectionUtils.toCollection((Object)attrValue, ArrayList.class);
            LOGGER.debug("Found attribute [{}] with value(s) [{}]", key, (Object)values);
            if (values.size() == 1) {
                Object value = values.get(0);
                convertedAttributes.put(key, value);
            } else {
                convertedAttributes.put(key, values);
            }
        });
        String principalId = extractedPrincipalId;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.principalAttributeNames)) {
            Set attrNames = StringUtils.commaDelimitedListToSet((String)this.principalAttributeNames);
            Optional<List> result = attrNames.stream().map(String::trim).filter(attributes::containsKey).map(attributes::get).findFirst();
            if (result.isPresent()) {
                List values = result.get();
                if (!values.isEmpty()) {
                    principalId = CollectionUtils.firstElement((Object)values).get().toString();
                    LOGGER.debug("Found principal id attribute value [{}] and removed it from the collection of attributes", (Object)principalId);
                }
            } else {
                LOGGER.warn("Principal resolution is set to resolve the authenticated principal via attribute(s) [{}], and yet the collection of attributes retrieved [{}] do not contain any of those attributes. This is likely due to misconfiguration and CAS will switch to use [{}] as the final principal id", new Object[]{this.principalAttributeNames, attributes.keySet(), principalId});
            }
        }
        return Pair.of((Object)principalId, convertedAttributes);
    }

    protected Map<String, List<Object>> retrievePersonAttributes(String principalId, Credential credential) {
        IPersonAttributes personAttributes = this.attributeRepository.getPerson(principalId);
        return personAttributes == null ? null : personAttributes.getAttributes();
    }

    protected String extractPrincipalId(Credential credential, Optional<Principal> currentPrincipal) {
        LOGGER.debug("Extracting credential id based on existing credential [{}]", (Object)credential);
        if (currentPrincipal != null && currentPrincipal.isPresent()) {
            Principal principal = currentPrincipal.get();
            LOGGER.debug("Principal is currently resolved is [{}]", (Object)principal);
            if (this.useCurrentPrincipalId) {
                LOGGER.debug("Using the existing resolved principal id [{}]", (Object)principal.getId());
                return principal.getId();
            }
        }
        String id = credential.getId();
        LOGGER.debug("Extracted principal id [{}]", (Object)id);
        return id;
    }

    @Generated
    public String toString() {
        return "PersonDirectoryPrincipalResolver(attributeRepository=" + this.attributeRepository + ", principalFactory=" + this.principalFactory + ", returnNullIfNoAttributes=" + this.returnNullIfNoAttributes + ", principalNameTransformer=" + this.principalNameTransformer + ", principalAttributeNames=" + this.principalAttributeNames + ", useCurrentPrincipalId=" + this.useCurrentPrincipalId + ")";
    }

    @Generated
    public PersonDirectoryPrincipalResolver(IPersonAttributeDao attributeRepository, PrincipalFactory principalFactory, boolean returnNullIfNoAttributes, PrincipalNameTransformer principalNameTransformer, String principalAttributeNames, boolean useCurrentPrincipalId) {
        this.attributeRepository = attributeRepository;
        this.principalFactory = principalFactory;
        this.returnNullIfNoAttributes = returnNullIfNoAttributes;
        this.principalNameTransformer = principalNameTransformer;
        this.principalAttributeNames = principalAttributeNames;
        this.useCurrentPrincipalId = useCurrentPrincipalId;
    }

    @Generated
    public IPersonAttributeDao getAttributeRepository() {
        return this.attributeRepository;
    }

    @Generated
    public PrincipalFactory getPrincipalFactory() {
        return this.principalFactory;
    }

    @Generated
    public boolean isReturnNullIfNoAttributes() {
        return this.returnNullIfNoAttributes;
    }

    @Generated
    public PrincipalNameTransformer getPrincipalNameTransformer() {
        return this.principalNameTransformer;
    }

    @Generated
    public String getPrincipalAttributeNames() {
        return this.principalAttributeNames;
    }

    @Generated
    public boolean isUseCurrentPrincipalId() {
        return this.useCurrentPrincipalId;
    }
}

