/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal.resolvers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.NullPrincipal;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.support.MergingPersonAttributeDaoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainingPrincipalResolver
implements PrincipalResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ChainingPrincipalResolver.class);
    private final PrincipalFactory principalFactory = new DefaultPrincipalFactory();
    private List<PrincipalResolver> chain;

    public Principal resolve(Credential credential, Optional<Principal> principal, Optional<AuthenticationHandler> handler) {
        ArrayList<Principal> principals = new ArrayList<Principal>();
        this.chain.stream().filter(resolver -> resolver.supports(credential)).forEach(resolver -> {
            LOGGER.debug("Invoking principal resolver [{}]", (Object)resolver.getName());
            Principal p = resolver.resolve(credential, principal, handler);
            if (p != null) {
                LOGGER.debug("Resolved principal [{}]", (Object)p);
                principals.add(p);
            }
        });
        if (principals.isEmpty()) {
            LOGGER.warn("None of the principal resolvers in the chain were able to produce a principal");
            return NullPrincipal.getInstance();
        }
        HashMap attributes = new HashMap();
        principals.forEach(p -> {
            if (p != null) {
                LOGGER.debug("Resolved principal [{}]", p);
                Map principalAttributes = p.getAttributes();
                if (principalAttributes != null && !principalAttributes.isEmpty()) {
                    LOGGER.debug("Adding attributes [{}] for the final principal", (Object)principalAttributes);
                    attributes.putAll(CoreAuthenticationUtils.mergeAttributes(attributes, principalAttributes));
                }
            }
        });
        LinkedHashSet principalIds = principals.stream().map(p -> p.getId().trim().toLowerCase()).collect(Collectors.toCollection(LinkedHashSet::new));
        int count = principalIds.size();
        if (count > 1) {
            LOGGER.debug("Principal resolvers produced [{}] distinct principal IDs [{}]; last resolved principal ID will be the final principal ID", (Object)count, (Object)principalIds);
        }
        String principalId = ((Principal)principals.get(principals.size() - 1)).getId();
        Principal finalPrincipal = this.principalFactory.createPrincipal(principalId, attributes);
        LOGGER.debug("Final principal constructed by the chain of resolvers is [{}]", (Object)finalPrincipal);
        return finalPrincipal;
    }

    public boolean supports(Credential credential) {
        return this.chain.get(0).supports(credential);
    }

    public IPersonAttributeDao getAttributeRepository() {
        MergingPersonAttributeDaoImpl dao = new MergingPersonAttributeDaoImpl();
        dao.setPersonAttributeDaos(this.chain.stream().map(PrincipalResolver::getAttributeRepository).collect(Collectors.toList()));
        return dao;
    }

    @Generated
    public String toString() {
        return "ChainingPrincipalResolver(principalFactory=" + this.principalFactory + ", chain=" + this.chain + ")";
    }

    @Generated
    public void setChain(List<PrincipalResolver> chain) {
        this.chain = chain;
    }
}

