/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.policy;

import java.security.GeneralSecurityException;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationPolicy;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniquePrincipalAuthenticationPolicy
implements AuthenticationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(UniquePrincipalAuthenticationPolicy.class);
    private final TicketRegistry ticketRegistry;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSatisfiedBy(Authentication authentication, Set<AuthenticationHandler> authenticationHandlers) throws Exception {
        try {
            Principal authPrincipal = authentication.getPrincipal();
            try (Stream ticketsStream = this.ticketRegistry.getTickets(t -> this.isSamePrincipalId((Ticket)t, authPrincipal));){
                long count = ticketsStream.count();
                if (count == 0L) {
                    LOGGER.debug("Authentication policy is satisfied with [{}]", (Object)authPrincipal.getId());
                    boolean bl2 = true;
                    return bl2;
                }
                LOGGER.warn("Authentication policy cannot be satisfied for principal [{}] because [{}] sessions currently exist", (Object)authPrincipal.getId(), (Object)count);
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e);
        }
    }

    private boolean isSamePrincipalId(Ticket t, Principal p) {
        return (Boolean)FunctionUtils.doIf((TicketGrantingTicket.class.isInstance(t) && !t.isExpired() ? 1 : 0) != 0, () -> {
            Principal principal = ((TicketGrantingTicket)TicketGrantingTicket.class.cast(t)).getAuthentication().getPrincipal();
            return principal.getId().equalsIgnoreCase(p.getId());
        }, () -> Boolean.TRUE).get();
    }

    @Generated
    public UniquePrincipalAuthenticationPolicy(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }
}

