/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.policy;

import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequiredHandlerAuthenticationPolicy
implements AuthenticationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RequiredHandlerAuthenticationPolicy.class);
    private final String requiredHandlerName;
    private final boolean tryAll;

    public RequiredHandlerAuthenticationPolicy(String requiredHandlerName) {
        this(requiredHandlerName, false);
    }

    public boolean isSatisfiedBy(Authentication authn, Set<AuthenticationHandler> authenticationHandlers) {
        boolean credsOk = true;
        int sum = authn.getSuccesses().size() + authn.getFailures().size();
        if (this.tryAll) {
            boolean bl = credsOk = authn.getCredentials().size() == sum;
        }
        if (!credsOk) {
            LOGGER.warn("Number of provided credentials [{}] does not match the sum of authentication successes and failures [{}]. Successful authentication handlers are [{}]", new Object[]{authn.getCredentials().size(), sum, authn.getSuccesses().keySet()});
            return false;
        }
        LOGGER.debug("Examining authentication successes for authentication handler [{}]", (Object)this.requiredHandlerName);
        if (StringUtils.isNotBlank((CharSequence)this.requiredHandlerName) && !(credsOk = authn.getSuccesses().keySet().stream().anyMatch(s -> s.equalsIgnoreCase(this.requiredHandlerName)))) {
            LOGGER.warn("Required authentication handler [{}] is not present in the list of recorded successful authentications", (Object)this.requiredHandlerName);
            return false;
        }
        LOGGER.debug("Authentication policy is satisfied");
        return true;
    }

    @Generated
    public RequiredHandlerAuthenticationPolicy(String requiredHandlerName, boolean tryAll) {
        this.requiredHandlerName = requiredHandlerName;
        this.tryAll = tryAll;
    }
}

