/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.policy;

import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationPolicy;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class GroovyScriptAuthenticationPolicy
implements AuthenticationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyScriptAuthenticationPolicy.class);
    private final ResourceLoader resourceLoader;
    private final String script;

    public boolean isSatisfiedBy(Authentication auth, Set<AuthenticationHandler> authenticationHandlers) throws Exception {
        Matcher matcherInline = ScriptingUtils.getMatcherForInlineGroovyScript((String)this.script);
        Optional<Exception> ex = this.getScriptExecutionResult(auth, matcherInline);
        if (ex != null && ex.isPresent()) {
            throw new GeneralSecurityException(ex.get());
        }
        return true;
    }

    private Optional<Exception> getScriptExecutionResult(Authentication auth, Matcher matcherInline) {
        if (matcherInline.find()) {
            Map args = CollectionUtils.wrap((String)"principal", (Object)auth.getPrincipal(), (String)"logger", (Object)LOGGER);
            String inlineScript = matcherInline.group(1);
            return (Optional)ScriptingUtils.executeGroovyShellScript((String)inlineScript, (Map)args, Optional.class);
        }
        Resource res = this.resourceLoader.getResource(this.script);
        Object[] args = new Object[]{auth.getPrincipal(), LOGGER};
        return (Optional)ScriptingUtils.executeGroovyScript((Resource)res, (Object[])args, Optional.class, (boolean)true);
    }

    @Generated
    public GroovyScriptAuthenticationPolicy(ResourceLoader resourceLoader, String script) {
        this.resourceLoader = resourceLoader;
        this.script = script;
    }
}

