/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.policy;

import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtLeastOneCredentialValidatedAuthenticationPolicy
implements AuthenticationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AtLeastOneCredentialValidatedAuthenticationPolicy.class);
    private final boolean tryAll;

    public boolean isSatisfiedBy(Authentication authn, Set<AuthenticationHandler> authenticationHandlers) throws Exception {
        if (this.tryAll) {
            int sum = authn.getSuccesses().size() + authn.getFailures().size();
            if (authn.getCredentials().size() != sum) {
                LOGGER.warn("Number of provided credentials [{}] does not match the sum of authentication successes and failures [{}]", (Object)authn.getCredentials().size(), (Object)sum);
                return false;
            }
            LOGGER.debug("Authentication policy is satisfied with all authentication transactions");
            return true;
        }
        if (!authn.getSuccesses().isEmpty()) {
            LOGGER.debug("Authentication policy is satisfied having found at least one authentication transactions");
            return true;
        }
        LOGGER.warn("Authentication policy has failed to find a successful authentication transaction");
        return false;
    }

    @Generated
    public AtLeastOneCredentialValidatedAuthenticationPolicy() {
        this.tryAll = false;
    }

    @Generated
    public AtLeastOneCredentialValidatedAuthenticationPolicy(boolean tryAll) {
        this.tryAll = tryAll;
    }
}

