/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.handler;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.handler.support.HttpBasedServiceCredentialsAuthenticationHandler;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedSsoServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredServiceAuthenticationHandlerResolver
implements AuthenticationHandlerResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceAuthenticationHandlerResolver.class);
    protected final ServicesManager servicesManager;

    public boolean supports(Set<AuthenticationHandler> handlers, AuthenticationTransaction transaction) {
        Service service = transaction.getService();
        if (service != null) {
            RegisteredService registeredService = this.servicesManager.findServiceBy(service);
            LOGGER.trace("Located registered service definition [{}] for this authentication transaction", (Object)registeredService);
            if (registeredService == null || !registeredService.getAccessStrategy().isServiceAccessAllowed()) {
                LOGGER.warn("Service [{}] is not allowed to use SSO.", (Object)service);
                throw new UnauthorizedSsoServiceException();
            }
            return !registeredService.getRequiredHandlers().isEmpty();
        }
        return false;
    }

    public Set<AuthenticationHandler> resolve(Set<AuthenticationHandler> candidateHandlers, AuthenticationTransaction transaction) {
        Service service = transaction.getService();
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        Set requiredHandlers = registeredService.getRequiredHandlers();
        LOGGER.debug("Authentication transaction requires [{}] for service [{}]", (Object)requiredHandlers, (Object)service);
        LinkedHashSet<AuthenticationHandler> handlerSet = new LinkedHashSet<AuthenticationHandler>(candidateHandlers);
        LOGGER.info("Candidate authentication handlers examined this transaction are [{}]", handlerSet);
        Iterator it = handlerSet.iterator();
        while (it.hasNext()) {
            AuthenticationHandler handler = (AuthenticationHandler)it.next();
            String handlerName = handler.getName();
            if (handler instanceof HttpBasedServiceCredentialsAuthenticationHandler || requiredHandlers.contains(handlerName)) continue;
            LOGGER.debug("Authentication handler [{}] is not required for this transaction and is removed", (Object)handlerName);
            it.remove();
        }
        LOGGER.debug("Authentication handlers for this transaction are [{}]", handlerSet);
        return handlerSet;
    }

    @Generated
    public RegisteredServiceAuthenticationHandlerResolver(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }
}

