/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.credential;

import javax.validation.constraints.Size;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.validation.ValidationContext;

public class UsernamePasswordCredential
implements Credential {
    public static final String AUTHENTICATION_ATTRIBUTE_PASSWORD = "credential";
    private static final long serialVersionUID = -700605081472810939L;
    @Size(min=1, message="username.required")
    private @Size(min=1, message="username.required") String username;
    @Size(min=1, message="password.required")
    private @Size(min=1, message="password.required") String password;
    private String source;

    public UsernamePasswordCredential(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String getId() {
        return this.username;
    }

    public void validate(ValidationContext context) {
        if (!context.getUserEvent().equalsIgnoreCase("submit")) {
            return;
        }
        MessageContext messages = context.getMessageContext();
        ApplicationContextProvider.getCasProperties().ifPresent(props -> {
            if (StringUtils.isBlank((CharSequence)this.source) && props.getAuthn().getPolicy().isSourceSelectionEnabled()) {
                messages.addMessage(new MessageBuilder().error().source((Object)"source").code("source.required").build());
            }
        });
    }

    @Generated
    public String toString() {
        return "UsernamePasswordCredential(username=" + this.username + ", source=" + this.source + ")";
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Generated
    public UsernamePasswordCredential() {
    }

    @Generated
    public UsernamePasswordCredential(String username, String password, String source) {
        this.username = username;
        this.password = password;
        this.source = source;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UsernamePasswordCredential)) {
            return false;
        }
        UsernamePasswordCredential other = (UsernamePasswordCredential)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.username;
        String other$username = other.username;
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.password;
        String other$password = other.password;
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$source = this.source;
        String other$source = other.source;
        return !(this$source == null ? other$source != null : !this$source.equals(other$source));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UsernamePasswordCredential;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.username;
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.password;
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $source = this.source;
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        return result;
    }
}

