/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.adaptive.intel;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.authentication.adaptive.intel.BaseIPAddressIntelligenceService;
import org.apereo.cas.authentication.adaptive.intel.IPAddressIntelligenceResponse;
import org.apereo.cas.configuration.model.core.authentication.AdaptiveAuthenticationIPIntelligenceProperties;
import org.apereo.cas.configuration.model.core.authentication.AdaptiveAuthenticationProperties;
import org.apereo.cas.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.webflow.execution.RequestContext;

public class RestfulIPAddressIntelligenceService
extends BaseIPAddressIntelligenceService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestfulIPAddressIntelligenceService.class);

    public RestfulIPAddressIntelligenceService(AdaptiveAuthenticationProperties adaptiveAuthenticationProperties) {
        super(adaptiveAuthenticationProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IPAddressIntelligenceResponse examineInternal(RequestContext context, String clientIpAddress) {
        HttpResponse response = null;
        try {
            AdaptiveAuthenticationIPIntelligenceProperties.Rest restProperties = this.adaptiveAuthenticationProperties.getIpIntel().getRest();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("clientIpAddress", clientIpAddress);
            response = HttpUtils.execute((String)restProperties.getUrl(), (String)HttpMethod.GET.name(), (String)restProperties.getBasicAuthUsername(), (String)restProperties.getBasicAuthPassword(), parameters, new HashMap());
            if (response != null) {
                HttpStatus status = HttpStatus.valueOf((int)response.getStatusLine().getStatusCode());
                if (status.equals((Object)HttpStatus.FORBIDDEN) || status.equals((Object)HttpStatus.UNAUTHORIZED)) {
                    IPAddressIntelligenceResponse iPAddressIntelligenceResponse = IPAddressIntelligenceResponse.banned();
                    HttpUtils.close((HttpResponse)response);
                    return iPAddressIntelligenceResponse;
                }
                if (status.equals((Object)HttpStatus.OK) || status.equals((Object)HttpStatus.ACCEPTED)) {
                    IPAddressIntelligenceResponse iPAddressIntelligenceResponse = IPAddressIntelligenceResponse.allowed();
                    HttpUtils.close((HttpResponse)response);
                    return iPAddressIntelligenceResponse;
                }
                double score = Double.parseDouble(IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
                IPAddressIntelligenceResponse iPAddressIntelligenceResponse = IPAddressIntelligenceResponse.builder().score(score).status(IPAddressIntelligenceResponse.IPAddressIntelligenceStatus.RANKED).build();
                HttpUtils.close((HttpResponse)response);
                return iPAddressIntelligenceResponse;
            }
            HttpUtils.close((HttpResponse)response);
            return IPAddressIntelligenceResponse.banned();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return IPAddressIntelligenceResponse.banned();
        }
        finally {
            HttpUtils.close(response);
        }
    }
}

