/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.adaptive.intel;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.authentication.adaptive.intel.BaseIPAddressIntelligenceService;
import org.apereo.cas.authentication.adaptive.intel.IPAddressIntelligenceResponse;
import org.apereo.cas.configuration.model.core.authentication.AdaptiveAuthenticationIPIntelligenceProperties;
import org.apereo.cas.configuration.model.core.authentication.AdaptiveAuthenticationProperties;
import org.apereo.cas.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.webflow.execution.RequestContext;

public class BlackDotIPAddressIntelligenceService
extends BaseIPAddressIntelligenceService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BlackDotIPAddressIntelligenceService.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().findAndRegisterModules();

    public BlackDotIPAddressIntelligenceService(AdaptiveAuthenticationProperties adaptiveAuthenticationProperties) {
        super(adaptiveAuthenticationProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IPAddressIntelligenceResponse examineInternal(RequestContext context, String clientIpAddress) {
        IPAddressIntelligenceResponse bannedResponse = IPAddressIntelligenceResponse.banned();
        HttpResponse response = null;
        try {
            AdaptiveAuthenticationIPIntelligenceProperties.BlackDot properties = this.adaptiveAuthenticationProperties.getIpIntel().getBlackDot();
            StringBuilder builder = new StringBuilder(String.format(properties.getUrl(), clientIpAddress));
            builder.append("&format=json");
            if (StringUtils.isNotBlank((CharSequence)properties.getEmailAddress())) {
                builder.append("&contact=");
                builder.append(properties.getEmailAddress());
            }
            switch (properties.getMode().toUpperCase()) {
                case "DYNA_LIST": {
                    builder.append("&flags=m");
                    break;
                }
                case "DYNA_CHECK": {
                    builder.append("&flags=b");
                    break;
                }
                default: {
                    builder.append("&flags=f");
                }
            }
            String url = builder.toString();
            LOGGER.debug("Sending IP check request to [{}]", (Object)url);
            response = HttpUtils.execute((String)url, (String)HttpMethod.GET.name());
            if (response == null) {
                IPAddressIntelligenceResponse iPAddressIntelligenceResponse = bannedResponse;
                HttpUtils.close((HttpResponse)response);
                return iPAddressIntelligenceResponse;
            }
            if (response.getStatusLine().getStatusCode() == HttpStatus.TOO_MANY_REQUESTS.value()) {
                LOGGER.error("Exceeded the number of allowed queries");
                IPAddressIntelligenceResponse iPAddressIntelligenceResponse = bannedResponse;
                HttpUtils.close((HttpResponse)response);
                return iPAddressIntelligenceResponse;
            }
            String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            LOGGER.debug("Received payload result after examining IP address [{}] as [{}]", (Object)clientIpAddress, (Object)result);
            Map json = (Map)MAPPER.readValue(result, Map.class);
            String status = json.getOrDefault("status", "error").toString();
            if ("success".equalsIgnoreCase(status)) {
                double rank = Double.parseDouble(((Object)json.getOrDefault("result", 1)).toString());
                if (rank == 1.0) {
                    IPAddressIntelligenceResponse iPAddressIntelligenceResponse = bannedResponse;
                    HttpUtils.close((HttpResponse)response);
                    return iPAddressIntelligenceResponse;
                }
                if (rank == 0.0) {
                    IPAddressIntelligenceResponse iPAddressIntelligenceResponse = IPAddressIntelligenceResponse.allowed();
                    HttpUtils.close((HttpResponse)response);
                    return iPAddressIntelligenceResponse;
                }
                IPAddressIntelligenceResponse iPAddressIntelligenceResponse = IPAddressIntelligenceResponse.builder().score(rank).status(IPAddressIntelligenceResponse.IPAddressIntelligenceStatus.RANKED).build();
                HttpUtils.close((HttpResponse)response);
                return iPAddressIntelligenceResponse;
            }
            String message = json.getOrDefault("message", "Invalid IP address").toString();
            LOGGER.error(message);
            IPAddressIntelligenceResponse iPAddressIntelligenceResponse = bannedResponse;
            HttpUtils.close((HttpResponse)response);
            return iPAddressIntelligenceResponse;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return bannedResponse;
        }
        finally {
            HttpUtils.close(response);
        }
    }
}

