/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.adaptive.intel;

import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.adaptive.intel.IPAddressIntelligenceResponse;
import org.apereo.cas.authentication.adaptive.intel.IPAddressIntelligenceService;
import org.apereo.cas.configuration.model.core.authentication.AdaptiveAuthenticationProperties;
import org.springframework.webflow.execution.RequestContext;

public abstract class BaseIPAddressIntelligenceService
implements IPAddressIntelligenceService {
    protected final AdaptiveAuthenticationProperties adaptiveAuthenticationProperties;

    private boolean isClientIpAddressRejected(String clientIp) {
        return StringUtils.isNotBlank((CharSequence)this.adaptiveAuthenticationProperties.getRejectIpAddresses()) && Pattern.compile(this.adaptiveAuthenticationProperties.getRejectIpAddresses()).matcher(clientIp).find();
    }

    public IPAddressIntelligenceResponse examine(RequestContext context, String clientIpAddress) {
        if (this.isClientIpAddressRejected(clientIpAddress)) {
            IPAddressIntelligenceResponse response = IPAddressIntelligenceResponse.banned();
            BaseIPAddressIntelligenceService.trackResponseInRequestContext(context, response);
            return response;
        }
        IPAddressIntelligenceResponse response = this.examineInternal(context, clientIpAddress);
        BaseIPAddressIntelligenceService.trackResponseInRequestContext(context, response);
        return response;
    }

    private static void trackResponseInRequestContext(RequestContext context, IPAddressIntelligenceResponse response) {
        context.getFlowScope().put("ipAddressIntelligenceResponse", (Object)response);
    }

    public abstract IPAddressIntelligenceResponse examineInternal(RequestContext var1, String var2);

    @Generated
    public BaseIPAddressIntelligenceService(AdaptiveAuthenticationProperties adaptiveAuthenticationProperties) {
        this.adaptiveAuthenticationProperties = adaptiveAuthenticationProperties;
    }
}

