/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationManager;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.AuthenticationTransactionManager;
import org.apereo.cas.support.events.authentication.CasAuthenticationTransactionCompletedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class DefaultAuthenticationTransactionManager
implements AuthenticationTransactionManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuthenticationTransactionManager.class);
    private final ApplicationEventPublisher eventPublisher;
    private final AuthenticationManager authenticationManager;

    public AuthenticationTransactionManager handle(AuthenticationTransaction authenticationTransaction, AuthenticationResultBuilder authenticationResult) throws AuthenticationException {
        if (!authenticationTransaction.getCredentials().isEmpty()) {
            Authentication authentication = this.authenticationManager.authenticate(authenticationTransaction);
            LOGGER.trace("Successful authentication; Collecting authentication result [{}]", (Object)authentication);
            this.publishEvent((ApplicationEvent)new CasAuthenticationTransactionCompletedEvent((Object)this, authentication));
            authenticationResult.collect(authentication);
        } else {
            LOGGER.debug("Transaction ignored since there are no credentials to authenticate");
        }
        return this;
    }

    private void publishEvent(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    @Generated
    public ApplicationEventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    @Generated
    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    @Generated
    public DefaultAuthenticationTransactionManager(ApplicationEventPublisher eventPublisher, AuthenticationManager authenticationManager) {
        this.eventPublisher = eventPublisher;
        this.authenticationManager = authenticationManager;
    }
}

