/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.AuthenticationTransactionManager;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationResultBuilder;
import org.apereo.cas.authentication.DefaultAuthenticationTransaction;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.principal.Service;

public class DefaultAuthenticationSystemSupport
implements AuthenticationSystemSupport {
    private final AuthenticationTransactionManager authenticationTransactionManager;
    private final PrincipalElectionStrategy principalElectionStrategy;

    public AuthenticationResultBuilder handleInitialAuthenticationTransaction(Service service, Credential ... credential) throws AuthenticationException {
        DefaultAuthenticationResultBuilder builder = new DefaultAuthenticationResultBuilder();
        if (credential != null) {
            Stream.of(credential).filter(Objects::nonNull).forEach(builder::collect);
        }
        return this.handleAuthenticationTransaction(service, builder, credential);
    }

    public AuthenticationResultBuilder establishAuthenticationContextFromInitial(Authentication authentication, Credential credentials) {
        return new DefaultAuthenticationResultBuilder().collect(authentication).collect(credentials);
    }

    public AuthenticationResultBuilder handleAuthenticationTransaction(Service service, AuthenticationResultBuilder authenticationResultBuilder, Credential ... credential) throws AuthenticationException {
        DefaultAuthenticationTransaction transaction = DefaultAuthenticationTransaction.of((Service)service, (Credential[])credential);
        this.authenticationTransactionManager.handle((AuthenticationTransaction)transaction, authenticationResultBuilder);
        return authenticationResultBuilder;
    }

    public AuthenticationResult finalizeAllAuthenticationTransactions(AuthenticationResultBuilder authenticationResultBuilder, Service service) {
        return authenticationResultBuilder.build(this.principalElectionStrategy, service);
    }

    public AuthenticationResult handleAndFinalizeSingleAuthenticationTransaction(Service service, Credential ... credential) throws AuthenticationException {
        return this.finalizeAllAuthenticationTransactions(this.handleInitialAuthenticationTransaction(service, credential), service);
    }

    @Generated
    public AuthenticationTransactionManager getAuthenticationTransactionManager() {
        return this.authenticationTransactionManager;
    }

    @Generated
    public PrincipalElectionStrategy getPrincipalElectionStrategy() {
        return this.principalElectionStrategy;
    }

    @Generated
    public DefaultAuthenticationSystemSupport(AuthenticationTransactionManager authenticationTransactionManager, PrincipalElectionStrategy principalElectionStrategy) {
        this.authenticationTransactionManager = authenticationTransactionManager;
        this.principalElectionStrategy = principalElectionStrategy;
    }
}

