/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi.config;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apereo.cas.audit.spi.CredentialsAsFirstParameterResourceResolver;
import org.apereo.cas.audit.spi.DefaultDelegatingAuditTrailManager;
import org.apereo.cas.audit.spi.DelegatingAuditTrailManager;
import org.apereo.cas.audit.spi.MessageBundleAwareResourceResolver;
import org.apereo.cas.audit.spi.PrincipalIdProvider;
import org.apereo.cas.audit.spi.ServiceResourceResolver;
import org.apereo.cas.audit.spi.ThreadLocalPrincipalResolver;
import org.apereo.cas.audit.spi.TicketAsFirstParameterResourceResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.audit.AuditProperties;
import org.apereo.inspektr.audit.AuditTrailManagementAspect;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.apereo.inspektr.audit.spi.support.ReturnValueAsStringResourceResolver;
import org.apereo.inspektr.audit.support.Slf4jLoggingAuditTrailManager;
import org.apereo.inspektr.common.spi.PrincipalResolver;
import org.apereo.inspektr.common.web.ClientInfoThreadLocalFilter;
import org.aspectj.lang.JoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.webflow.execution.Event;

@Configuration(value="casCoreAuditConfiguration")
@EnableAspectJAutoProxy
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreAuditConfiguration {
    private static final String AUDIT_ACTION_SUFFIX_FAILED = "_FAILED";
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    public AuditTrailManagementAspect auditTrailManagementAspect(@Qualifier(value="auditTrailManager") AuditTrailManager auditTrailManager) {
        AuditTrailManagementAspect aspect = new AuditTrailManagementAspect(this.casProperties.getAudit().getAppCode(), this.auditablePrincipalResolver(this.principalIdProvider()), Collections.singletonList(auditTrailManager), this.auditActionResolverMap(), this.auditResourceResolverMap());
        aspect.setFailOnAuditFailures(!this.casProperties.getAudit().isIgnoreAuditFailures());
        return aspect;
    }

    @ConditionalOnMissingBean(name={"auditTrailManager"})
    @Bean
    public DelegatingAuditTrailManager auditTrailManager() {
        Slf4jLoggingAuditTrailManager mgmr = new Slf4jLoggingAuditTrailManager();
        mgmr.setUseSingleLine(this.casProperties.getAudit().isUseSingleLine());
        mgmr.setEntrySeparator(this.casProperties.getAudit().getSinglelineSeparator());
        mgmr.setAuditFormat(this.casProperties.getAudit().getAuditFormat());
        return new DefaultDelegatingAuditTrailManager((AuditTrailManager)mgmr);
    }

    @Bean
    public FilterRegistrationBean casClientInfoLoggingFilter() {
        AuditProperties audit = this.casProperties.getAudit();
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new ClientInfoThreadLocalFilter());
        bean.setUrlPatterns(Collections.singleton("/*"));
        bean.setName("CAS Client Info Logging Filter");
        bean.setAsyncSupported(true);
        bean.setOrder(Integer.MIN_VALUE);
        HashMap<String, String> initParams = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)audit.getAlternateClientAddrHeaderName())) {
            initParams.put("alternativeIpAddressHeader", audit.getAlternateClientAddrHeaderName());
        }
        if (StringUtils.isNotBlank((CharSequence)audit.getAlternateServerAddrHeaderName())) {
            initParams.put("alternateServerAddrHeaderName", audit.getAlternateServerAddrHeaderName());
        }
        initParams.put("useServerHostAddress", String.valueOf(audit.isUseServerHostAddress()));
        bean.setInitParameters(initParams);
        return bean;
    }

    @ConditionalOnMissingBean(name={"authenticationActionResolver"})
    @Bean
    public AuditActionResolver authenticationActionResolver() {
        return new DefaultAuditActionResolver("_SUCCESS", AUDIT_ACTION_SUFFIX_FAILED);
    }

    @ConditionalOnMissingBean(name={"ticketCreationActionResolver"})
    @Bean
    public AuditActionResolver ticketCreationActionResolver() {
        return new DefaultAuditActionResolver("_CREATED", "_NOT_CREATED");
    }

    @ConditionalOnMissingBean(name={"ticketValidationActionResolver"})
    @Bean
    public AuditActionResolver ticketValidationActionResolver() {
        return new DefaultAuditActionResolver("D", AUDIT_ACTION_SUFFIX_FAILED);
    }

    @ConditionalOnMissingBean(name={"returnValueResourceResolver"})
    @Bean
    public AuditResourceResolver returnValueResourceResolver() {
        return new ReturnValueAsStringResourceResolver();
    }

    @ConditionalOnMissingBean(name={"nullableReturnValueResourceResolver"})
    @Bean
    public AuditResourceResolver nullableReturnValueResourceResolver() {
        return new AuditResourceResolver(){

            public String[] resolveFrom(JoinPoint joinPoint, Object o) {
                if (o == null) {
                    return new String[0];
                }
                if (o instanceof Event) {
                    Event event = (Event)Event.class.cast(o);
                    String sourceName = event.getSource().getClass().getSimpleName();
                    String result = new ToStringBuilder((Object)event, ToStringStyle.NO_CLASS_NAME_STYLE).append("event", (Object)event.getId()).append("timestamp", (Object)new Date(event.getTimestamp())).append("source", (Object)sourceName).toString();
                    return new String[]{result};
                }
                return CasCoreAuditConfiguration.this.returnValueResourceResolver().resolveFrom(joinPoint, o);
            }

            public String[] resolveFrom(JoinPoint joinPoint, Exception e) {
                return CasCoreAuditConfiguration.this.returnValueResourceResolver().resolveFrom(joinPoint, e);
            }
        };
    }

    @ConditionalOnMissingBean(name={"auditActionResolverMap"})
    @Bean
    public Map<String, AuditActionResolver> auditActionResolverMap() {
        HashMap<String, AuditActionResolver> map = new HashMap<String, AuditActionResolver>();
        AuditActionResolver resolver = this.authenticationActionResolver();
        map.put("AUTHENTICATION_RESOLVER", resolver);
        map.put("SAVE_SERVICE_ACTION_RESOLVER", resolver);
        map.put("CHANGE_PASSWORD_ACTION_RESOLVER", resolver);
        DefaultAuditActionResolver defResolver = new DefaultAuditActionResolver();
        map.put("DESTROY_TICKET_GRANTING_TICKET_RESOLVER", (AuditActionResolver)defResolver);
        map.put("DESTROY_PROXY_GRANTING_TICKET_RESOLVER", (AuditActionResolver)defResolver);
        AuditActionResolver cResolver = this.ticketCreationActionResolver();
        map.put("CREATE_PROXY_GRANTING_TICKET_RESOLVER", cResolver);
        map.put("GRANT_SERVICE_TICKET_RESOLVER", cResolver);
        map.put("GRANT_PROXY_TICKET_RESOLVER", cResolver);
        map.put("CREATE_TICKET_GRANTING_TICKET_RESOLVER", cResolver);
        map.put("TRUSTED_AUTHENTICATION_ACTION_RESOLVER", cResolver);
        map.put("AUTHENTICATION_EVENT_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_TRIGGERED", ""));
        DefaultAuditActionResolver adResolver = new DefaultAuditActionResolver();
        map.put("ADAPTIVE_RISKY_AUTHENTICATION_ACTION_RESOLVER", (AuditActionResolver)adResolver);
        map.put("VALIDATE_SERVICE_TICKET_RESOLVER", this.ticketValidationActionResolver());
        return map;
    }

    @ConditionalOnMissingBean(name={"auditResourceResolverMap"})
    @Bean
    public Map<String, AuditResourceResolver> auditResourceResolverMap() {
        HashMap<String, AuditResourceResolver> map = new HashMap<String, AuditResourceResolver>();
        map.put("AUTHENTICATION_RESOURCE_RESOLVER", new CredentialsAsFirstParameterResourceResolver());
        map.put("CREATE_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER", this.messageBundleAwareResourceResolver());
        map.put("CREATE_PROXY_GRANTING_TICKET_RESOURCE_RESOLVER", this.messageBundleAwareResourceResolver());
        map.put("DESTROY_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER", this.ticketResourceResolver());
        map.put("DESTROY_PROXY_GRANTING_TICKET_RESOURCE_RESOLVER", this.ticketResourceResolver());
        map.put("GRANT_SERVICE_TICKET_RESOURCE_RESOLVER", new ServiceResourceResolver());
        map.put("GRANT_PROXY_TICKET_RESOURCE_RESOLVER", new ServiceResourceResolver());
        map.put("VALIDATE_SERVICE_TICKET_RESOURCE_RESOLVER", this.ticketResourceResolver());
        map.put("SAVE_SERVICE_RESOURCE_RESOLVER", this.returnValueResourceResolver());
        map.put("CHANGE_PASSWORD_RESOURCE_RESOLVER", this.returnValueResourceResolver());
        map.put("TRUSTED_AUTHENTICATION_RESOURCE_RESOLVER", this.returnValueResourceResolver());
        map.put("ADAPTIVE_RISKY_AUTHENTICATION_RESOURCE_RESOLVER", this.returnValueResourceResolver());
        map.put("AUTHENTICATION_EVENT_RESOURCE_RESOLVER", this.nullableReturnValueResourceResolver());
        return map;
    }

    @ConditionalOnMissingBean(name={"auditablePrincipalResolver"})
    @Bean
    public PrincipalResolver auditablePrincipalResolver(@Qualifier(value="principalIdProvider") PrincipalIdProvider principalIdProvider) {
        return new ThreadLocalPrincipalResolver(principalIdProvider);
    }

    @ConditionalOnMissingBean(name={"ticketResourceResolver"})
    @Bean
    public AuditResourceResolver ticketResourceResolver() {
        return new TicketAsFirstParameterResourceResolver();
    }

    @ConditionalOnMissingBean(name={"messageBundleAwareResourceResolver"})
    @Bean
    public AuditResourceResolver messageBundleAwareResourceResolver() {
        return new MessageBundleAwareResourceResolver();
    }

    @ConditionalOnMissingBean(name={"principalIdProvider"})
    @Bean
    public PrincipalIdProvider principalIdProvider() {
        return new PrincipalIdProvider(){};
    }
}

