/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi;

import java.util.Arrays;
import java.util.Collection;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.spi.PrincipalIdProvider;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.AopUtils;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.common.spi.PrincipalResolver;
import org.aspectj.lang.JoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class TicketOrCredentialPrincipalResolver
implements PrincipalResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketOrCredentialPrincipalResolver.class);
    private CentralAuthenticationService centralAuthenticationService;
    private PrincipalIdProvider principalIdProvider = new PrincipalIdProvider(){};

    public TicketOrCredentialPrincipalResolver(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public String resolveFrom(JoinPoint joinPoint, Object retVal) {
        return this.resolveFromInternal(AopUtils.unWrapJoinPoint((JoinPoint)joinPoint));
    }

    public String resolveFrom(JoinPoint joinPoint, Exception retVal) {
        return this.resolveFromInternal(AopUtils.unWrapJoinPoint((JoinPoint)joinPoint));
    }

    public String resolve() {
        return "audit:unknown";
    }

    protected String resolveFromInternal(JoinPoint joinPoint) {
        StringBuilder builder = new StringBuilder();
        Object arg1 = joinPoint.getArgs()[0];
        if (arg1.getClass().isArray()) {
            Object[] args1AsArray = (Object[])arg1;
            this.resolveArguments(builder, args1AsArray);
        } else {
            builder.append(this.resolveArgument(arg1));
        }
        return builder.toString();
    }

    private String resolveArguments(StringBuilder builder, Collection args1AsArray) {
        args1AsArray.stream().forEach(arg -> builder.append(this.resolveArgument(arg)));
        return builder.toString();
    }

    private String resolveArguments(StringBuilder builder, Object[] args1AsArray) {
        Arrays.stream(args1AsArray).forEach(arg -> builder.append(this.resolveArgument(arg)));
        return builder.toString();
    }

    private String resolveArgument(Object arg1) {
        LOGGER.debug("Resolving argument [{}] for audit", (Object)arg1.getClass().getSimpleName());
        if (arg1 instanceof AuthenticationTransaction) {
            AuthenticationTransaction transaction = (AuthenticationTransaction)AuthenticationTransaction.class.cast(arg1);
            return this.resolveArguments(new StringBuilder(), transaction.getCredentials());
        }
        if (arg1 instanceof Credential) {
            return arg1.toString();
        }
        if (arg1 instanceof String) {
            try {
                Ticket ticket = this.centralAuthenticationService.getTicket((String)arg1, Ticket.class);
                Authentication authentication = null;
                if (ticket instanceof ServiceTicket) {
                    authentication = ((ServiceTicket)ServiceTicket.class.cast(ticket)).getGrantingTicket().getAuthentication();
                } else if (ticket instanceof TicketGrantingTicket) {
                    authentication = ((TicketGrantingTicket)TicketGrantingTicket.class.cast(ticket)).getAuthentication();
                }
                return this.principalIdProvider.getPrincipalIdFrom(authentication);
            }
            catch (InvalidTicketException e) {
                LOGGER.trace(e.getMessage(), (Throwable)e);
                LOGGER.debug("Could not locate ticket [{}] in the registry", arg1);
            }
        }
        return WebUtils.getAuthenticatedUsername();
    }

    public PrincipalIdProvider getPrincipalIdProvider() {
        return this.principalIdProvider;
    }

    public void setPrincipalIdProvider(PrincipalIdProvider principalIdProvider) {
        this.principalIdProvider = principalIdProvider;
    }
}

