/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi;

import org.apereo.cas.audit.spi.PrincipalIdProvider;
import org.apereo.cas.authentication.AuthenticationCredentialsLocalBinder;
import org.apereo.inspektr.common.spi.PrincipalResolver;
import org.aspectj.lang.JoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalPrincipalResolver
implements PrincipalResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadLocalPrincipalResolver.class);
    private PrincipalIdProvider principalIdProvider;

    public ThreadLocalPrincipalResolver(PrincipalIdProvider principalIdProvider) {
        this.principalIdProvider = principalIdProvider;
    }

    public String resolveFrom(JoinPoint auditTarget, Object returnValue) {
        LOGGER.trace("Resolving principal at audit point [{}]", (Object)auditTarget);
        return this.getCurrentPrincipal();
    }

    public String resolveFrom(JoinPoint auditTarget, Exception exception) {
        LOGGER.trace("Resolving principal at audit point [{}] with thrown exception [{}]", (Object)auditTarget, (Object)exception);
        return this.getCurrentPrincipal();
    }

    public String resolve() {
        return "audit:unknown";
    }

    private String getCurrentPrincipal() {
        String principal = this.principalIdProvider.getPrincipalIdFrom(AuthenticationCredentialsLocalBinder.getCurrentAuthentication());
        if (principal == null) {
            principal = AuthenticationCredentialsLocalBinder.getCurrentCredentialIdsAsString();
        }
        return principal != null ? principal : "audit:unknown";
    }
}

